/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.eval;

import at.petrak.hexcasting.api.HexAPI;
import at.petrak.hexcasting.api.casting.ParticleSpray;
import at.petrak.hexcasting.api.casting.PatternShapeMatch;
import at.petrak.hexcasting.api.casting.eval.CastResult;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironmentComponent;
import at.petrak.hexcasting.api.casting.eval.MishapEnvironment;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapBadLocation;
import at.petrak.hexcasting.api.casting.mishaps.MishapDisallowedSpell;
import at.petrak.hexcasting.api.casting.mishaps.MishapEntityTooFarAway;
import at.petrak.hexcasting.api.mod.HexConfig;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.HexUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_161;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CastingEnvironment {
    private static final List<BiConsumer<CastingEnvironment, class_2487>> createEventListeners = new ArrayList<BiConsumer<CastingEnvironment, class_2487>>();
    private boolean createEventTriggered = false;
    protected final class_3218 world;
    protected Map<CastingEnvironmentComponent.Key<?>, @NotNull CastingEnvironmentComponent> componentMap = new HashMap();
    private final List<CastingEnvironmentComponent.PostExecution> postExecutions = new ArrayList<CastingEnvironmentComponent.PostExecution>();
    private final List<CastingEnvironmentComponent.PostCast> postCasts = new ArrayList<CastingEnvironmentComponent.PostCast>();
    private final List<CastingEnvironmentComponent.ExtractMedia.Pre> preMediaExtract = new ArrayList<CastingEnvironmentComponent.ExtractMedia.Pre>();
    private final List<CastingEnvironmentComponent.ExtractMedia.Post> postMediaExtract = new ArrayList<CastingEnvironmentComponent.ExtractMedia.Post>();
    private final List<CastingEnvironmentComponent.IsVecInRange> isVecInRanges = new ArrayList<CastingEnvironmentComponent.IsVecInRange>();
    private final List<CastingEnvironmentComponent.HasEditPermissionsAt> hasEditPermissionsAts = new ArrayList<CastingEnvironmentComponent.HasEditPermissionsAt>();

    public static void addCreateEventListener(BiConsumer<CastingEnvironment, class_2487> listener) {
        createEventListeners.add(listener);
    }

    @Deprecated(since="0.11.0-pre-660")
    public static void addCreateEventListener(Consumer<CastingEnvironment> listener) {
        createEventListeners.add((env, data) -> listener.accept((CastingEnvironment)env));
    }

    public final void triggerCreateEvent(class_2487 userData) {
        if (!this.createEventTriggered) {
            for (BiConsumer<CastingEnvironment, class_2487> listener : createEventListeners) {
                listener.accept(this, userData);
            }
            this.createEventTriggered = true;
        }
    }

    protected CastingEnvironment(class_3218 world) {
        this.world = world;
    }

    public final class_3218 getWorld() {
        return this.world;
    }

    public int maxOpCount() {
        return HexConfig.server().maxOpCount();
    }

    @Deprecated(since="0.11.1-7-pre-619")
    @Nullable
    public class_3222 getCaster() {
        class_3222 sp;
        class_1309 class_13092 = this.getCastingEntity();
        return class_13092 instanceof class_3222 ? (sp = (class_3222)class_13092) : null;
    }

    @Nullable
    public abstract class_1309 getCastingEntity();

    public abstract MishapEnvironment getMishapEnvironment();

    public <T extends CastingEnvironmentComponent> void addExtension(@NotNull T extension) {
        this.componentMap.put(extension.getKey(), extension);
        if (extension instanceof CastingEnvironmentComponent.PostExecution) {
            CastingEnvironmentComponent.PostExecution postExecution = (CastingEnvironmentComponent.PostExecution)extension;
            this.postExecutions.add(postExecution);
        }
        if (extension instanceof CastingEnvironmentComponent.PostCast) {
            CastingEnvironmentComponent.PostCast postCast = (CastingEnvironmentComponent.PostCast)extension;
            this.postCasts.add(postCast);
        }
        if (extension instanceof CastingEnvironmentComponent.ExtractMedia) {
            CastingEnvironmentComponent.ExtractMedia extractMedia = (CastingEnvironmentComponent.ExtractMedia)extension;
            if (extension instanceof CastingEnvironmentComponent.ExtractMedia.Pre) {
                CastingEnvironmentComponent.ExtractMedia.Pre pre = (CastingEnvironmentComponent.ExtractMedia.Pre)extension;
                this.preMediaExtract.add(pre);
            } else if (extension instanceof CastingEnvironmentComponent.ExtractMedia.Post) {
                CastingEnvironmentComponent.ExtractMedia.Post post = (CastingEnvironmentComponent.ExtractMedia.Post)extension;
                this.postMediaExtract.add(post);
            }
        }
        if (extension instanceof CastingEnvironmentComponent.IsVecInRange) {
            CastingEnvironmentComponent.IsVecInRange isVecInRange = (CastingEnvironmentComponent.IsVecInRange)extension;
            this.isVecInRanges.add(isVecInRange);
        }
        if (extension instanceof CastingEnvironmentComponent.HasEditPermissionsAt) {
            CastingEnvironmentComponent.HasEditPermissionsAt hasEditPermissionsAt = (CastingEnvironmentComponent.HasEditPermissionsAt)extension;
            this.hasEditPermissionsAts.add(hasEditPermissionsAt);
        }
    }

    public void removeExtension(@NotNull CastingEnvironmentComponent.Key<?> key) {
        CastingEnvironmentComponent extension = this.componentMap.remove(key);
        if (extension == null) {
            return;
        }
        if (extension instanceof CastingEnvironmentComponent.PostExecution) {
            CastingEnvironmentComponent.PostExecution postExecution = (CastingEnvironmentComponent.PostExecution)extension;
            this.postExecutions.remove(postExecution);
        }
        if (extension instanceof CastingEnvironmentComponent.PostCast) {
            CastingEnvironmentComponent.PostCast postCast = (CastingEnvironmentComponent.PostCast)extension;
            this.postCasts.remove(postCast);
        }
        if (extension instanceof CastingEnvironmentComponent.ExtractMedia) {
            CastingEnvironmentComponent.ExtractMedia extractMedia = (CastingEnvironmentComponent.ExtractMedia)extension;
            if (extension instanceof CastingEnvironmentComponent.ExtractMedia.Pre) {
                CastingEnvironmentComponent.ExtractMedia.Pre pre = (CastingEnvironmentComponent.ExtractMedia.Pre)extension;
                this.preMediaExtract.remove(pre);
            } else if (extension instanceof CastingEnvironmentComponent.ExtractMedia.Post) {
                CastingEnvironmentComponent.ExtractMedia.Post post = (CastingEnvironmentComponent.ExtractMedia.Post)extension;
                this.postMediaExtract.remove(post);
            }
        }
        if (extension instanceof CastingEnvironmentComponent.IsVecInRange) {
            CastingEnvironmentComponent.IsVecInRange isVecInRange = (CastingEnvironmentComponent.IsVecInRange)extension;
            this.isVecInRanges.remove(isVecInRange);
        }
        if (extension instanceof CastingEnvironmentComponent.HasEditPermissionsAt) {
            CastingEnvironmentComponent.HasEditPermissionsAt hasEditPermissionsAt = (CastingEnvironmentComponent.HasEditPermissionsAt)extension;
            this.hasEditPermissionsAts.remove(hasEditPermissionsAt);
        }
    }

    @Nullable
    public <T extends CastingEnvironmentComponent> T getExtension(@NotNull CastingEnvironmentComponent.Key<T> key) {
        return (T)this.componentMap.get(key);
    }

    public void precheckAction(PatternShapeMatch match) throws Mishap {
        class_2960 key = this.actionKey(match);
        if (!HexConfig.server().isActionAllowed(key)) {
            throw new MishapDisallowedSpell();
        }
    }

    @Nullable
    protected class_2960 actionKey(PatternShapeMatch match) {
        class_2960 key;
        if (match instanceof PatternShapeMatch.Normal) {
            PatternShapeMatch.Normal normal = (PatternShapeMatch.Normal)match;
            key = normal.key.method_29177();
        } else if (match instanceof PatternShapeMatch.PerWorld) {
            PatternShapeMatch.PerWorld perWorld = (PatternShapeMatch.PerWorld)match;
            key = perWorld.key.method_29177();
        } else if (match instanceof PatternShapeMatch.Special) {
            PatternShapeMatch.Special special = (PatternShapeMatch.Special)match;
            key = special.key.method_29177();
        } else {
            key = null;
        }
        return key;
    }

    public void postExecution(CastResult result) {
        for (CastingEnvironmentComponent.PostExecution postExecutionComponent : this.postExecutions) {
            postExecutionComponent.onPostExecution(result);
        }
    }

    public void postCast(CastingImage image) {
        for (CastingEnvironmentComponent.PostCast postCastComponent : this.postCasts) {
            postCastComponent.onPostCast(image);
        }
    }

    public abstract class_243 mishapSprayPos();

    public boolean isEnlightened() {
        class_161 adv = this.world.method_8503().method_3851().method_12896(HexAPI.modLoc("enlightenment"));
        if (adv == null) {
            return false;
        }
        class_1309 caster = this.getCastingEntity();
        if (caster instanceof class_3222) {
            class_3222 player = (class_3222)caster;
            return player.method_14236().method_12882(adv).method_740();
        }
        return false;
    }

    public long extractMedia(long cost, boolean simulate) {
        for (CastingEnvironmentComponent.ExtractMedia.Pre pre : this.preMediaExtract) {
            cost = pre.onExtractMedia(cost, simulate);
        }
        cost = this.extractMediaEnvironment(cost, simulate);
        for (CastingEnvironmentComponent.ExtractMedia.Post post : this.postMediaExtract) {
            cost = post.onExtractMedia(cost, simulate);
        }
        return cost;
    }

    protected abstract long extractMediaEnvironment(long var1, boolean var3);

    public boolean isVecInRange(class_243 vec) {
        boolean isInRange = this.isVecInRangeEnvironment(vec);
        for (CastingEnvironmentComponent.IsVecInRange isVecInRangeComponent : this.isVecInRanges) {
            isInRange = isVecInRangeComponent.onIsVecInRange(vec, isInRange);
        }
        return isInRange;
    }

    protected abstract boolean isVecInRangeEnvironment(class_243 var1);

    public boolean hasEditPermissionsAt(class_2338 pos) {
        boolean hasEditPermissionsAt = this.hasEditPermissionsAtEnvironment(pos);
        for (CastingEnvironmentComponent.HasEditPermissionsAt hasEditPermissionsAtComponent : this.hasEditPermissionsAts) {
            hasEditPermissionsAt = hasEditPermissionsAtComponent.onHasEditPermissionsAt(pos, hasEditPermissionsAt);
        }
        return hasEditPermissionsAt;
    }

    protected abstract boolean hasEditPermissionsAtEnvironment(class_2338 var1);

    public final boolean isVecInWorld(class_243 vec) {
        return this.world.method_24794(class_2338.method_49638((class_2374)vec)) && this.world.method_8621().method_39458(vec.field_1352, vec.field_1350, 0.5);
    }

    public final boolean isVecInAmbit(class_243 vec) {
        return this.isVecInRange(vec) && this.isVecInWorld(vec);
    }

    public final boolean isEntityInRange(class_1297 e) {
        return this.isEntityInRange(e, false);
    }

    public final boolean isEntityInRange(class_1297 e, boolean ignoreTruenameAmbit) {
        boolean truenameCheat = !ignoreTruenameAmbit && e instanceof class_1657 && HexConfig.server().trueNameHasAmbit();
        return truenameCheat || this.isVecInWorld(e.method_19538()) && this.isVecInRange(e.method_19538());
    }

    public final void assertVecInRange(class_243 vec) throws MishapBadLocation {
        this.assertVecInWorld(vec);
        if (!this.isVecInRange(vec)) {
            throw new MishapBadLocation(vec, "too_far");
        }
    }

    public final void assertPosInRange(class_2338 vec) throws MishapBadLocation {
        this.assertVecInRange(new class_243((double)vec.method_10263(), (double)vec.method_10264(), (double)vec.method_10260()));
    }

    public final void assertPosInRangeForEditing(class_2338 vec) throws MishapBadLocation {
        this.assertVecInRange(new class_243((double)vec.method_10263(), (double)vec.method_10264(), (double)vec.method_10260()));
        if (!this.canEditBlockAt(vec)) {
            throw new MishapBadLocation(class_243.method_24953((class_2382)vec), "forbidden");
        }
    }

    public final boolean canEditBlockAt(class_2338 vec) {
        return this.isVecInRange(class_243.method_24953((class_2382)vec)) && this.hasEditPermissionsAt(vec);
    }

    public final void assertEntityInRange(class_1297 e) throws MishapEntityTooFarAway {
        if (e instanceof class_3222 && HexConfig.server().trueNameHasAmbit()) {
            return;
        }
        if (!this.isVecInWorld(e.method_19538())) {
            throw new MishapEntityTooFarAway(e);
        }
        if (!this.isVecInRange(e.method_19538())) {
            throw new MishapEntityTooFarAway(e);
        }
    }

    public final void assertVecInWorld(class_243 vec) throws MishapBadLocation {
        if (!this.isVecInWorld(vec)) {
            throw new MishapBadLocation(vec, "out_of_world");
        }
    }

    public abstract class_1268 getCastingHand();

    public class_1268 getOtherHand() {
        return HexUtils.otherHand(this.getCastingHand());
    }

    protected abstract List<class_1799> getUsableStacks(StackDiscoveryMode var1);

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected List<class_1799> getUsableStacksForPlayer(StackDiscoveryMode mode, @Nullable class_1268 castingHand, class_3222 caster) {
        switch (mode) {
            default: {
                throw new IncompatibleClassChangeError();
            }
            case QUERY: {
                ArrayList<class_1799> out = new ArrayList<class_1799>();
                if (castingHand == null) {
                    class_1799 offhand;
                    class_1799 mainhand = caster.method_5998(class_1268.field_5808);
                    if (!mainhand.method_7960()) {
                        out.add(mainhand);
                    }
                    if (!(offhand = caster.method_5998(class_1268.field_5810)).method_7960()) {
                        out.add(offhand);
                    }
                } else {
                    class_1799 offhand = caster.method_5998(HexUtils.otherHand(castingHand));
                    if (!offhand.method_7960()) {
                        out.add(offhand);
                    }
                }
                int anchorSlot = castingHand != class_1268.field_5810 ? (caster.method_31548().field_7545 + 1) % 9 : 0;
                for (int delta = 0; delta < 9; ++delta) {
                    int slot = (anchorSlot + delta) % 9;
                    out.add(caster.method_31548().method_5438(slot));
                }
                ArrayList<class_1799> arrayList = out;
                return arrayList;
            }
            case EXTRACTION: {
                ArrayList<class_1799> out = new ArrayList<class_1799>();
                class_1661 inv = caster.method_31548();
                for (int i = inv.field_7547.size() - 1; i >= 0; --i) {
                    if (i == inv.field_7545) continue;
                    out.add((class_1799)inv.field_7547.get(i));
                }
                out.addAll((Collection<class_1799>)inv.field_7544);
                out.add(inv.method_7391());
                ArrayList<class_1799> arrayList = out;
                return arrayList;
            }
        }
    }

    protected abstract List<HeldItemInfo> getPrimaryStacks();

    protected List<HeldItemInfo> getPrimaryStacksForPlayer(class_1268 castingHand, class_3222 caster) {
        class_1799 secondaryItem;
        class_1799 primaryItem = caster.method_5998(castingHand);
        if (primaryItem.method_7960()) {
            primaryItem = class_1799.field_8037.method_7972();
        }
        if ((secondaryItem = caster.method_5998(HexUtils.otherHand(castingHand))).method_7960()) {
            secondaryItem = class_1799.field_8037.method_7972();
        }
        return List.of(new HeldItemInfo(secondaryItem, HexUtils.otherHand(castingHand)), new HeldItemInfo(primaryItem, castingHand));
    }

    @Nullable
    public class_1799 queryForMatchingStack(Predicate<class_1799> stackOk) {
        List<class_1799> stacks = this.getUsableStacks(StackDiscoveryMode.QUERY);
        for (class_1799 stack : stacks) {
            if (!stackOk.test(stack)) continue;
            return stack;
        }
        return null;
    }

    @Nullable
    public HeldItemInfo getHeldItemToOperateOn(Predicate<class_1799> stackOk) {
        List<HeldItemInfo> stacks = this.getPrimaryStacks();
        for (HeldItemInfo stack : stacks) {
            if (!stackOk.test(stack.stack)) continue;
            return stack;
        }
        return null;
    }

    protected boolean isCreativeMode() {
        return false;
    }

    public boolean withdrawItem(Predicate<class_1799> stackOk, int count, boolean actuallyRemove) {
        if (this.isCreativeMode()) {
            return true;
        }
        List<class_1799> stacks = this.getUsableStacks(StackDiscoveryMode.EXTRACTION);
        int presentCount = 0;
        ArrayList<class_1799> matches = new ArrayList<class_1799>();
        for (class_1799 stack : stacks) {
            if (!stackOk.test(stack)) continue;
            matches.add(stack);
            if ((presentCount += stack.method_7947()) < count) continue;
            break;
        }
        if (presentCount < count) {
            return false;
        }
        if (!actuallyRemove) {
            return true;
        }
        int remaining = count;
        for (class_1799 match : matches) {
            int toWithdraw = Math.min(match.method_7947(), remaining);
            match.method_7934(toWithdraw);
            if ((remaining -= toWithdraw) > 0) continue;
            return true;
        }
        throw new IllegalStateException("unreachable");
    }

    public abstract boolean replaceItem(Predicate<class_1799> var1, class_1799 var2, @Nullable class_1268 var3);

    public boolean replaceItemForPlayer(Predicate<class_1799> stackOk, class_1799 replaceWith, @Nullable class_1268 hand, class_3222 caster) {
        if (caster == null) {
            return false;
        }
        if (hand != null && stackOk.test(caster.method_5998(hand))) {
            caster.method_6122(hand, replaceWith);
            return true;
        }
        class_1661 inv = caster.method_31548();
        for (int i = inv.field_7547.size() - 1; i >= 0; --i) {
            if (i == inv.field_7545 || !stackOk.test((class_1799)inv.field_7547.get(i))) continue;
            inv.method_5447(i, replaceWith);
            return true;
        }
        if (stackOk.test(caster.method_5998(this.getOtherHand()))) {
            caster.method_6122(this.getOtherHand(), replaceWith);
            return true;
        }
        if (stackOk.test(caster.method_5998(this.getCastingHand()))) {
            caster.method_6122(this.getCastingHand(), replaceWith);
            return true;
        }
        return false;
    }

    public abstract FrozenPigment getPigment();

    @Nullable
    public abstract FrozenPigment setPigment(@Nullable FrozenPigment var1);

    public abstract void produceParticles(ParticleSpray var1, FrozenPigment var2);

    public abstract void printMessage(class_2561 var1);

    protected static enum StackDiscoveryMode {
        QUERY,
        EXTRACTION;

    }

    public record HeldItemInfo(class_1799 stack, @Nullable class_1268 hand) {
        public class_1799 component1() {
            return this.stack;
        }

        @Nullable
        public class_1268 component2() {
            return this.hand;
        }
    }
}

