/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.circles;

import at.petrak.hexcasting.api.block.HexBlockEntity;
import at.petrak.hexcasting.api.block.circle.BlockCircleComponent;
import at.petrak.hexcasting.api.casting.circles.CircleExecutionState;
import at.petrak.hexcasting.api.casting.circles.ICircleComponent;
import at.petrak.hexcasting.api.misc.Result;
import at.petrak.hexcasting.api.pigment.FrozenPigment;
import at.petrak.hexcasting.api.utils.MediaHelper;
import at.petrak.hexcasting.common.items.magic.ItemCreativeUnlocker;
import at.petrak.hexcasting.common.lib.HexItems;
import com.mojang.datafixers.util.Pair;
import java.text.DecimalFormat;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1278;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_2741;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5250;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.Nullable;

public abstract class BlockEntityAbstractImpetus
extends HexBlockEntity
implements class_1278 {
    private static final DecimalFormat DUST_AMOUNT = new DecimalFormat("###,###.##");
    private static final long MAX_CAPACITY = 9000000000000000000L;
    public static final String TAG_EXECUTION_STATE = "executor";
    public static final String TAG_MEDIA = "media";
    public static final String TAG_ERROR_MSG = "errorMsg";
    public static final String TAG_ERROR_DISPLAY = "errorDisplay";
    public static final String TAG_PIGMENT = "pigment";
    @Nullable
    class_2487 lazyExecutionState;
    @Nullable
    protected CircleExecutionState executionState;
    protected long media = 0L;
    @Nullable
    protected class_2561 displayMsg = null;
    @Nullable
    protected class_1799 displayItem = null;
    @Nullable
    protected FrozenPigment pigment = null;
    private static final int[] MAJOR_SCALE = new int[]{0, 2, 4, 5, 7, 9, 11, 12};
    private static final int[] MINOR_SCALE = new int[]{0, 2, 3, 5, 7, 8, 11, 12};
    private static final int[] DORIAN_SCALE = new int[]{0, 2, 3, 5, 7, 9, 10, 12};
    private static final int[] MIXOLYDIAN_SCALE = new int[]{0, 2, 4, 5, 7, 9, 10, 12};
    private static final int[] BLUES_SCALE = new int[]{0, 3, 5, 6, 7, 10, 12};
    private static final int[] BAD_TIME = new int[]{0, 0, 12, 7, 6, 5, 3, 0, 3, 5};
    private static final int[] SUSSY_BAKA = new int[]{5, 8, 10, 11, 10, 8, 5, 3, 7, 5};
    private static final int[] SLOTS = new int[]{0};

    public BlockEntityAbstractImpetus(class_2591<?> pType, class_2338 pWorldPosition, class_2680 pBlockState) {
        super(pType, pWorldPosition, pBlockState);
    }

    public class_2350 getStartDirection() {
        return (class_2350)this.method_11010().method_11654((class_2769)class_2741.field_12525);
    }

    @Nullable
    public class_2561 getDisplayMsg() {
        return this.displayMsg;
    }

    public void clearDisplay() {
        this.displayMsg = null;
        this.displayItem = null;
        this.sync();
    }

    public void postDisplay(class_2561 error, class_1799 display) {
        this.displayMsg = error;
        this.displayItem = display;
        this.sync();
    }

    public void postMishap(class_2561 mishapDisplay) {
        this.postDisplay(mishapDisplay, new class_1799((class_1935)class_1802.field_8731));
    }

    public void postPrint(class_2561 printDisplay) {
        this.postDisplay(printDisplay, new class_1799((class_1935)class_1802.field_8529));
    }

    public void postNoExits(class_2338 pos) {
        this.postDisplay((class_2561)class_2561.method_43469((String)"hexcasting.tooltip.circle.no_exit", (Object[])new Object[]{class_2561.method_43470((String)pos.method_23854()).method_27692(class_124.field_1061)}), new class_1799((class_1935)class_1802.field_8788));
    }

    public void tickExecution() {
        if (this.field_11863 == null) {
            return;
        }
        this.method_5431();
        CircleExecutionState state = this.getExecutionState();
        if (state == null) {
            return;
        }
        boolean shouldContinue = state.tick(this);
        if (!shouldContinue) {
            this.endExecution();
            this.executionState = null;
        } else {
            this.field_11863.method_39279(this.method_11016(), this.method_11010().method_26204(), state.getTickSpeed());
        }
    }

    public void endExecution() {
        if (this.executionState == null) {
            return;
        }
        this.executionState.endExecution(this);
    }

    @Nullable
    public CircleExecutionState getExecutionState() {
        if (this.field_11863 == null) {
            throw new IllegalStateException("didn't you read the doc comment, don't call this if the level is null");
        }
        if (this.executionState != null) {
            return this.executionState;
        }
        if (this.lazyExecutionState != null) {
            this.executionState = CircleExecutionState.load(this.lazyExecutionState, (class_3218)this.field_11863);
        }
        return this.executionState;
    }

    public void startExecution(@Nullable class_3222 player) {
        if (this.field_11863 == null) {
            return;
        }
        if (this.field_11863.field_9236) {
            return;
        }
        if (this.executionState != null) {
            return;
        }
        Result<CircleExecutionState, class_2338> result = CircleExecutionState.createNew(this, player);
        if (result.isErr()) {
            class_2338 errPos = result.unwrapErr();
            if (errPos == null) {
                ICircleComponent.sfx(this.method_11016(), this.method_11010(), this.field_11863, null, false);
                this.postNoExits(this.method_11016());
            } else {
                ICircleComponent.sfx(errPos, this.field_11863.method_8320(errPos), this.field_11863, null, false);
                this.postDisplay((class_2561)class_2561.method_43469((String)"hexcasting.tooltip.circle.no_closure", (Object[])new Object[]{class_2561.method_43470((String)errPos.method_23854()).method_27692(class_124.field_1061)}), new class_1799((class_1935)class_1802.field_8719));
            }
            return;
        }
        this.executionState = result.unwrap();
        this.clearDisplay();
        class_3218 serverLevel = (class_3218)this.field_11863;
        serverLevel.method_39279(this.method_11016(), this.method_11010().method_26204(), this.executionState.getTickSpeed());
        serverLevel.method_8501(this.method_11016(), (class_2680)this.method_11010().method_11657((class_2769)BlockCircleComponent.ENERGIZED, (Comparable)Boolean.valueOf(true)));
    }

    @Contract(pure=true)
    protected static class_238 getBounds(List<class_2338> poses) {
        int minX = Integer.MAX_VALUE;
        int minY = Integer.MAX_VALUE;
        int minZ = Integer.MAX_VALUE;
        int maxX = Integer.MIN_VALUE;
        int maxY = Integer.MIN_VALUE;
        int maxZ = Integer.MIN_VALUE;
        for (class_2338 pos : poses) {
            if (pos.method_10263() < minX) {
                minX = pos.method_10263();
            }
            if (pos.method_10264() < minY) {
                minY = pos.method_10264();
            }
            if (pos.method_10260() < minZ) {
                minZ = pos.method_10260();
            }
            if (pos.method_10263() > maxX) {
                maxX = pos.method_10263();
            }
            if (pos.method_10264() > maxY) {
                maxY = pos.method_10264();
            }
            if (pos.method_10260() <= maxZ) continue;
            maxZ = pos.method_10260();
        }
        return new class_238((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    public long getMedia() {
        return this.media;
    }

    public void setMedia(long media) {
        this.media = media;
        this.sync();
    }

    public long extractMediaFromInsertedItem(class_1799 stack, boolean simulate) {
        if (this.media < 0L) {
            return 0L;
        }
        return MediaHelper.extractMedia(stack, this.remainingMediaCapacity(), true, simulate);
    }

    public void insertMedia(class_1799 stack) {
        if (this.getMedia() >= 0L && !stack.method_7960() && stack.method_7909() == HexItems.CREATIVE_UNLOCKER) {
            this.setInfiniteMedia();
            stack.method_7934(1);
        } else {
            long mediamount = this.extractMediaFromInsertedItem(stack, false);
            if (mediamount > 0L) {
                this.media = Math.min(mediamount + this.media, 9000000000000000000L);
                this.sync();
            }
        }
    }

    public void setInfiniteMedia() {
        this.media = -1L;
        this.sync();
    }

    public long remainingMediaCapacity() {
        if (this.media < 0L) {
            return 0L;
        }
        return Math.max(0L, 9000000000000000000L - this.media);
    }

    public FrozenPigment getPigment() {
        if (this.pigment != null) {
            return this.pigment;
        }
        if (this.executionState != null && this.executionState.casterPigment != null) {
            return this.executionState.casterPigment;
        }
        return FrozenPigment.DEFAULT.get();
    }

    @Nullable
    public FrozenPigment setPigment(@Nullable FrozenPigment pigment) {
        this.pigment = pigment;
        return this.pigment;
    }

    @Override
    protected void saveModData(class_2487 tag) {
        if (this.executionState != null) {
            tag.method_10566(TAG_EXECUTION_STATE, (class_2520)this.executionState.save());
        }
        tag.method_10544(TAG_MEDIA, this.media);
        if (this.displayMsg != null && this.displayItem != null) {
            tag.method_10582(TAG_ERROR_MSG, class_2561.class_2562.method_10867((class_2561)this.displayMsg));
            class_2487 itemTag = new class_2487();
            this.displayItem.method_7953(itemTag);
            tag.method_10566(TAG_ERROR_DISPLAY, (class_2520)itemTag);
        }
        if (this.pigment != null) {
            tag.method_10566(TAG_PIGMENT, (class_2520)this.pigment.serializeToNBT());
        }
    }

    @Override
    protected void loadModData(class_2487 tag) {
        this.executionState = null;
        this.lazyExecutionState = tag.method_10573(TAG_EXECUTION_STATE, 10) ? tag.method_10562(TAG_EXECUTION_STATE) : null;
        if (tag.method_10573(TAG_MEDIA, 4)) {
            this.media = tag.method_10537(TAG_MEDIA);
        }
        if (tag.method_10573(TAG_ERROR_MSG, 8) && tag.method_10573(TAG_ERROR_DISPLAY, 10)) {
            class_5250 msg = class_2561.class_2562.method_10877((String)tag.method_10558(TAG_ERROR_MSG));
            class_1799 display = class_1799.method_7915((class_2487)tag.method_10562(TAG_ERROR_DISPLAY));
            this.displayMsg = msg;
            this.displayItem = display;
        } else {
            this.displayMsg = null;
            this.displayItem = null;
        }
        if (tag.method_10573(TAG_PIGMENT, 10)) {
            this.pigment = FrozenPigment.fromNBT(tag.method_10562(TAG_PIGMENT));
        }
    }

    public void applyScryingLensOverlay(List<Pair<class_1799, class_2561>> lines, class_2680 state, class_2338 pos, class_1657 observer, class_1937 world, class_2350 hitFace) {
        class_2586 class_25862 = world.method_8321(pos);
        if (class_25862 instanceof BlockEntityAbstractImpetus) {
            BlockEntityAbstractImpetus beai = (BlockEntityAbstractImpetus)class_25862;
            if (beai.getMedia() < 0L) {
                lines.add((Pair<class_1799, class_2561>)new Pair((Object)new class_1799((class_1935)HexItems.AMETHYST_DUST), (Object)ItemCreativeUnlocker.infiniteMedia(world)));
            } else {
                float dustCount = (float)beai.getMedia() / 10000.0f;
                class_5250 dustCmp = class_2561.method_43469((String)"hexcasting.tooltip.media", (Object[])new Object[]{DUST_AMOUNT.format(dustCount)});
                lines.add((Pair<class_1799, class_2561>)new Pair((Object)new class_1799((class_1935)HexItems.AMETHYST_DUST), (Object)dustCmp));
            }
            if (this.displayMsg != null && this.displayItem != null) {
                lines.add((Pair<class_1799, class_2561>)new Pair((Object)this.displayItem, (Object)this.displayMsg));
            }
        }
    }

    protected int semitoneFromScale(int note) {
        class_2680 blockBelow = this.field_11863.method_8320(this.method_11016().method_10074());
        int[] scale = MAJOR_SCALE;
        if (blockBelow.method_27852(class_2246.field_22423)) {
            scale = MINOR_SCALE;
        } else if (blockBelow.method_26164(class_3481.field_15495) || blockBelow.method_26164(class_3481.field_15487)) {
            scale = DORIAN_SCALE;
        } else if (blockBelow.method_27852(class_2246.field_10560) || blockBelow.method_27852(class_2246.field_10615)) {
            scale = MIXOLYDIAN_SCALE;
        } else if (blockBelow.method_27852(class_2246.field_10514) || blockBelow.method_27852(class_2246.field_10011) || blockBelow.method_27852(class_2246.field_10456) || blockBelow.method_27852(class_2246.field_10409) || blockBelow.method_27852(class_2246.field_10550) || blockBelow.method_27852(class_2246.field_10060) || blockBelow.method_27852(class_2246.field_9982)) {
            scale = BLUES_SCALE;
        } else if (blockBelow.method_27852(class_2246.field_10166)) {
            scale = BAD_TIME;
        } else if (blockBelow.method_27852(class_2246.field_17563)) {
            scale = SUSSY_BAKA;
        }
        note = class_3532.method_15340((int)note, (int)0, (int)(scale.length - 1));
        return scale[note];
    }

    public int[] method_5494(class_2350 var1) {
        return SLOTS;
    }

    public boolean method_5492(int index, class_1799 stack, @Nullable class_2350 dir) {
        return this.method_5437(index, stack);
    }

    public boolean method_5493(int var1, class_1799 var2, class_2350 var3) {
        return false;
    }

    public int method_5439() {
        return 1;
    }

    public boolean method_5442() {
        return true;
    }

    public class_1799 method_5438(int index) {
        return class_1799.field_8037.method_7972();
    }

    public class_1799 method_5434(int index, int count) {
        return class_1799.field_8037.method_7972();
    }

    public class_1799 method_5441(int index) {
        return class_1799.field_8037.method_7972();
    }

    public void method_5447(int index, class_1799 stack) {
        this.insertMedia(stack);
    }

    public boolean method_5443(class_1657 player) {
        return false;
    }

    public void method_5448() {
    }

    public boolean method_5437(int index, class_1799 stack) {
        if (this.remainingMediaCapacity() == 0L) {
            return false;
        }
        if (stack.method_31574((class_1792)HexItems.CREATIVE_UNLOCKER)) {
            return true;
        }
        long mediamount = this.extractMediaFromInsertedItem(stack, true);
        return mediamount > 0L;
    }
}

