/*
 * Decompiled with CFR 0.152.
 */
package at.petrak.hexcasting.api.casting.arithmetic.engine;

import at.petrak.hexcasting.api.casting.arithmetic.Arithmetic;
import at.petrak.hexcasting.api.casting.arithmetic.engine.HashCons;
import at.petrak.hexcasting.api.casting.arithmetic.engine.InvalidOperatorException;
import at.petrak.hexcasting.api.casting.arithmetic.engine.NoOperatorCandidatesException;
import at.petrak.hexcasting.api.casting.arithmetic.operator.Operator;
import at.petrak.hexcasting.api.casting.eval.CastingEnvironment;
import at.petrak.hexcasting.api.casting.eval.OperationResult;
import at.petrak.hexcasting.api.casting.eval.vm.CastingImage;
import at.petrak.hexcasting.api.casting.eval.vm.SpellContinuation;
import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.math.HexPattern;
import at.petrak.hexcasting.api.casting.mishaps.Mishap;
import at.petrak.hexcasting.api.casting.mishaps.MishapNotEnoughArgs;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Stack;

public class ArithmeticEngine {
    public final Arithmetic[] arithmetics;
    private final Map<HexPattern, OpCandidates> operators = new HashMap<HexPattern, OpCandidates>();
    private final Map<HashCons, Operator> cache = new HashMap<HashCons, Operator>();

    public ArithmeticEngine(List<Arithmetic> arithmetics) {
        this.arithmetics = arithmetics.toArray(new Arithmetic[0]);
        for (Arithmetic arith : arithmetics) {
            for (HexPattern op : arith.opTypes()) {
                this.operators.compute(op, ($, info) -> {
                    Operator operator = arith.getOperator(op);
                    if (info == null) {
                        info = new OpCandidates(op, operator.arity, new ArrayList<Operator>());
                    }
                    info.addOp(operator);
                    return info;
                });
            }
        }
    }

    public Iterable<HexPattern> operatorSyms() {
        return this.operators.keySet();
    }

    public OperationResult run(HexPattern pattern, CastingEnvironment env, CastingImage image, SpellContinuation continuation) throws Mishap {
        List<Iota> stackList = image.getStack();
        Stack<Iota> stack = new Stack<Iota>();
        stack.addAll(stackList);
        int startingLength = stackList.size();
        OpCandidates candidates = this.operators.get(pattern);
        if (candidates == null) {
            throw new InvalidOperatorException("the pattern " + pattern + " is not an operator.");
        }
        Record hash = new HashCons.Pattern(pattern);
        ArrayList<Iota> args = new ArrayList<Iota>(candidates.arity());
        for (int i = 0; i < candidates.arity(); ++i) {
            if (stack.isEmpty()) {
                throw new MishapNotEnoughArgs(candidates.arity, startingLength);
            }
            Iota iota = (Iota)stack.pop();
            hash = new HashCons.Pair(iota.getType(), (HashCons)((Object)hash));
            args.add(iota);
        }
        Collections.reverse(args);
        Operator op = this.resolveCandidates((List<Iota>)args, (HashCons)((Object)hash), candidates);
        return op.operate(env, image, continuation);
    }

    private Operator resolveCandidates(List<Iota> args, HashCons hash, OpCandidates candidates) {
        return this.cache.computeIfAbsent(hash, $ -> {
            for (Operator op : candidates.operators()) {
                if (!op.accepts.test(args)) continue;
                return op;
            }
            throw new NoOperatorCandidatesException(candidates.pattern(), args, "No implementation candidates for op " + candidates.pattern() + " on args: " + args);
        });
    }

    private record OpCandidates(HexPattern pattern, int arity, List<Operator> operators) {
        public void addOp(Operator next) {
            if (next.arity != this.arity) {
                throw new IllegalArgumentException("Operators exist of differing arity! The pattern " + this.pattern + " already had arity " + this.arity + " when the operator with arity " + next.arity + ", " + next + " was added.");
            }
            this.operators.add(next);
        }
    }
}

