/*
 * Decompiled with CFR 0.152.
 */
package com.blackgear.platform.core.util.config;

import com.blackgear.platform.core.Environment;
import com.blackgear.platform.core.events.ConfigEvents;
import com.blackgear.platform.core.util.config.ConfigTracker;
import com.blackgear.platform.core.util.config.IConfigSpec;
import com.blackgear.platform.nightconfig.core.CommentedConfig;
import com.blackgear.platform.nightconfig.core.ConfigFormat;
import com.blackgear.platform.nightconfig.core.file.CommentedFileConfig;
import com.blackgear.platform.nightconfig.core.file.FileWatcher;
import com.blackgear.platform.nightconfig.core.io.ParsingException;
import com.blackgear.platform.nightconfig.core.io.WritingMode;
import com.blackgear.platform.nightconfig.toml.TomlFormat;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Locale;
import java.util.function.Function;
import org.apache.commons.io.FilenameUtils;

public class ModConfig {
    private final Type type;
    private final IConfigSpec<?> spec;
    private final String fileName;
    private final String modId;
    private CommentedConfig configData;

    public ModConfig(Type type, IConfigSpec<?> spec, String modId, String fileName) {
        this.type = type;
        this.spec = spec;
        this.fileName = fileName;
        this.modId = modId;
        ConfigTracker.INSTANCE.trackConfig(this);
    }

    public ModConfig(Type type, IConfigSpec<?> spec, String modId) {
        this(type, spec, modId, ModConfig.defaultConfigName(type, modId));
    }

    private static String defaultConfigName(Type type, String modId) {
        return String.format(Locale.ROOT, "%s-%s.toml", modId, type.extension());
    }

    public Type getType() {
        return this.type;
    }

    public String getFileName() {
        return this.fileName;
    }

    public void unload(Path configBasePath) {
        Path configPath = configBasePath.resolve(this.getFileName());
        try {
            FileWatcher.defaultInstance().removeWatch(configBasePath.resolve(this.getFileName()));
        }
        catch (RuntimeException exception) {
            ConfigTracker.LOGGER.error("Failed to remove config {} from tracker!", (Object)configPath, (Object)exception);
        }
    }

    private boolean setupConfigFile(ModConfig modConfig, Path file, ConfigFormat<?> format) throws IOException {
        Files.createDirectories(file.getParent(), new FileAttribute[0]);
        Path path = Environment.getConfigDir().resolve(modConfig.getFileName());
        if (Files.exists(path, new LinkOption[0])) {
            ConfigTracker.LOGGER.info(ConfigTracker.CONFIG, "Loading default config file from path {}", (Object)path);
            Files.copy(path, file, new CopyOption[0]);
        } else {
            Files.createFile(file, new FileAttribute[0]);
            format.initEmptyFile(file);
        }
        return true;
    }

    public Function<ModConfig, CommentedFileConfig> reader(Path configBasePath) {
        return config -> {
            Path configPath = configBasePath.resolve(config.getFileName());
            CommentedFileConfig configData = (CommentedFileConfig)CommentedFileConfig.builder(configPath).sync().preserveInsertionOrder().autosave().onFileNotFound((file, format) -> this.setupConfigFile((ModConfig)config, file, format)).writingMode(WritingMode.REPLACE).build();
            ConfigTracker.LOGGER.debug(ConfigTracker.CONFIG, "Built TOML config for {}", (Object)configPath.toString());
            try {
                configData.load();
            }
            catch (ParsingException exception) {
                throw new ConfigLoadingException((ModConfig)config, exception);
            }
            ConfigTracker.LOGGER.debug(ConfigTracker.CONFIG, "Loaded TOML config file {}", (Object)configPath.toString());
            try {
                FileWatcher.defaultInstance().addWatch(configPath, (Runnable)new ConfigWatcher((ModConfig)config, configData, Thread.currentThread().getContextClassLoader()));
                ConfigTracker.LOGGER.debug(ConfigTracker.CONFIG, "Watching TOML config file {} for changes", (Object)configPath.toString());
            }
            catch (IOException exception) {
                throw new RuntimeException("Couldn't watch config file", exception);
            }
            return configData;
        };
    }

    public <T extends IConfigSpec<T>> IConfigSpec<T> getSpec() {
        return this.spec;
    }

    public String getModId() {
        return this.modId;
    }

    public CommentedConfig getConfigData() {
        return this.configData;
    }

    void setConfigData(CommentedConfig configData) {
        this.configData = configData;
        this.spec.setConfig(this.configData);
    }

    public void save() {
        ((CommentedFileConfig)this.configData).save();
    }

    public Path getFullPath() {
        return ((CommentedFileConfig)this.configData).getNioPath();
    }

    public void acceptSyncedConfig(byte[] bytes) {
        this.setConfigData((CommentedConfig)TomlFormat.instance().createParser().parse(new ByteArrayInputStream(bytes)));
        ConfigEvents.RELOADING.invoker().onModConfig(this);
    }

    public static void backUpConfig(CommentedFileConfig commentedFileConfig, int maxBackups) {
        Path bakFileLocation = commentedFileConfig.getNioPath().getParent();
        String bakFileName = FilenameUtils.removeExtension((String)commentedFileConfig.getFile().getName());
        String bakFileExtension = FilenameUtils.getExtension((String)commentedFileConfig.getFile().getName()) + ".bak";
        Path bakFile = bakFileLocation.resolve(bakFileName + "-1." + bakFileExtension);
        try {
            for (int i = maxBackups; i > 0; --i) {
                Path oldBak = bakFileLocation.resolve(bakFileName + "-" + i + "." + bakFileExtension);
                if (!Files.exists(oldBak, new LinkOption[0])) continue;
                if (i >= maxBackups) {
                    Files.delete(oldBak);
                    continue;
                }
                Files.move(oldBak, bakFileLocation.resolve(bakFileName + "-" + (i + 1) + "." + bakFileExtension), new CopyOption[0]);
            }
            Files.copy(commentedFileConfig.getNioPath(), bakFile, new CopyOption[0]);
        }
        catch (IOException exception) {
            ConfigTracker.LOGGER.warn(ConfigTracker.CONFIG, "Failed to back up config file {}", (Object)commentedFileConfig);
        }
    }

    public static enum Type {
        COMMON,
        CLIENT,
        SERVER;


        public String extension() {
            return this.name().toLowerCase(Locale.ROOT);
        }
    }

    private static class ConfigLoadingException
    extends RuntimeException {
        public ConfigLoadingException(ModConfig config, Exception cause) {
            super("Failed loading config file " + config.getFileName() + " of type " + config.getType() + " for modid " + config.getModId(), cause);
        }
    }

    private record ConfigWatcher(ModConfig modConfig, CommentedFileConfig commentedFileConfig, ClassLoader realClassLoader) implements Runnable
    {
        @Override
        public void run() {
            Thread.currentThread().setContextClassLoader(this.realClassLoader);
            if (!this.modConfig.getSpec().isCorrecting()) {
                try {
                    this.commentedFileConfig.load();
                    if (!this.modConfig.getSpec().isCorrect(this.commentedFileConfig)) {
                        ConfigTracker.LOGGER.warn(ConfigTracker.CONFIG, "Configuration file {} is not correct. Correcting", (Object)this.commentedFileConfig.getFile().getAbsolutePath());
                        ModConfig.backUpConfig(this.commentedFileConfig, 5);
                        this.modConfig.getSpec().correct(this.commentedFileConfig);
                        this.commentedFileConfig.save();
                    }
                }
                catch (ParsingException exception) {
                    throw new ConfigLoadingException(this.modConfig, exception);
                }
                ConfigTracker.LOGGER.debug(ConfigTracker.CONFIG, "Config file {} changed, sending notifies", (Object)this.modConfig.getFileName());
                this.modConfig.getSpec().afterReload();
                ConfigEvents.RELOADING.invoker().onModConfig(this.modConfig);
            }
        }
    }
}

