/*
 * Decompiled with CFR 0.152.
 */
package com.seibel.distanthorizons.forge;

import com.seibel.distanthorizons.core.network.messages.AbstractNetworkMessage;
import com.seibel.distanthorizons.core.wrapperInterfaces.misc.IServerPlayerWrapper;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import loaderCommon.forge.com.seibel.distanthorizons.common.AbstractPluginPacketSender;
import loaderCommon.forge.com.seibel.distanthorizons.common.wrappers.misc.ServerPlayerWrapper;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public class ForgePluginPacketSender
extends AbstractPluginPacketSender {
    public static final SimpleChannel PLUGIN_CHANNEL = NetworkRegistry.newSimpleChannel((ResourceLocation)AbstractPluginPacketSender.WRAPPER_PACKET_RESOURCE, () -> "1", ignored -> true, ignored -> true);

    public static void setPacketHandler(Consumer<AbstractNetworkMessage> consumer) {
        ForgePluginPacketSender.setPacketHandler((IServerPlayerWrapper player, AbstractNetworkMessage message) -> consumer.accept((AbstractNetworkMessage)message));
    }

    public static void setPacketHandler(BiConsumer<IServerPlayerWrapper, AbstractNetworkMessage> consumer) {
        PLUGIN_CHANNEL.registerMessage(0, MessageWrapper.class, (wrapper, out) -> AbstractPluginPacketSender.encodeMessage(out, wrapper.message), in -> new MessageWrapper(AbstractPluginPacketSender.decodeMessage(in)), (wrapper, context) -> {
            if (wrapper.message != null) {
                if (((NetworkEvent.Context)context.get()).getSender() != null) {
                    consumer.accept(ServerPlayerWrapper.getWrapper(((NetworkEvent.Context)context.get()).getSender()), wrapper.message);
                } else {
                    consumer.accept(null, wrapper.message);
                }
            }
            ((NetworkEvent.Context)context.get()).setPacketHandled(true);
        });
    }

    @Override
    public void sendToServer(AbstractNetworkMessage message) {
        PLUGIN_CHANNEL.send(PacketDistributor.SERVER.noArg(), (Object)new MessageWrapper(message));
    }

    @Override
    public void sendToClient(ServerPlayer serverPlayer, AbstractNetworkMessage message) {
        PLUGIN_CHANNEL.send(PacketDistributor.PLAYER.with(() -> serverPlayer), (Object)new MessageWrapper(message));
    }

    public static class MessageWrapper {
        public final AbstractNetworkMessage message;

        public MessageWrapper(AbstractNetworkMessage message) {
            this.message = message;
        }
    }
}

