/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.util;

import com.tom.peripherals.util.Pair;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Stream;

public class MapStream<T> {
    private Stream<Pair<String, T>> stream;

    public MapStream(Stream<Pair<String, T>> stream) {
        this.stream = stream;
    }

    public static <T> MapStream<T> of(Map<String, T> map) {
        return new MapStream<T>(map.entrySet().stream().map(e -> Pair.of((String)e.getKey(), e.getValue())));
    }

    public <R> MapStream<R> mapOValue(Function<T, R> f) {
        return new MapStream<T>(this.stream.map(p -> Pair.of((String)p.getKey(), f.apply(p.getValue()))));
    }

    public void put(Map<String, T> map) {
        this.stream.forEach(e -> map.put((String)e.getKey(), e.getValue()));
    }
}

