/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.gpu;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.gpu.BaseGPU;
import com.tom.peripherals.gpu.Rect;
import com.tom.peripherals.gpu.VRAM;

public class WindowGPUContext
implements BaseGPU.GPUContext,
VRAM.VRAMObject {
    private final BaseGPU.GPUContext ctx;
    private final Rect rect;
    private int[][] screen;
    private Runnable recalc;

    public WindowGPUContext(BaseGPU.GPUContext ctx, Rect rect) {
        this.ctx = ctx;
        this.rect = rect;
        this.screen = new int[rect.getW()][rect.getH()];
    }

    @Override
    public void set(int x, int y, int c) {
        if (x < this.screen.length && x >= 0 && y >= 0 && y < this.screen[0].length) {
            this.screen[x][y] = c;
        }
    }

    @Override
    public void sync() throws LuaException {
        int xs = this.rect.getX();
        int ys = this.rect.getY();
        int iw = this.rect.getW();
        int ih = this.rect.getH();
        if (this.screen.length != iw || this.screen[0].length != ih) {
            if (iw < 1 || ih < 1) {
                throw new LuaException("Invalid window size");
            }
            this.ctx.getVRam().reallocEx(this, iw * ih * 4);
            this.screen = new int[iw][ih];
            if (this.recalc != null) {
                this.recalc.run();
            }
            return;
        }
        int w = this.ctx.getWidth();
        int h = this.ctx.getHeight();
        for (int x = Math.max(-xs, 0); x + xs < w && x < iw; ++x) {
            int[] js = this.screen[x];
            for (int y = Math.max(-ys, 0); y + ys < h && y < ih; ++y) {
                int c = js[y];
                this.ctx.set(x + xs, y + ys, c);
            }
        }
    }

    @Override
    public int getWidth() {
        return this.rect.getW();
    }

    @Override
    public int getHeight() {
        return this.rect.getH();
    }

    @Override
    public VRAM getVRam() {
        return this.ctx.getVRam();
    }

    public int[][] getScreen() {
        return this.screen;
    }

    public void setRecalc(Runnable recalc) {
        this.recalc = recalc;
    }

    @Override
    public long getSize() {
        return this.rect.getW() + this.rect.getH();
    }

    @Override
    public Rect getBounds() {
        return this.rect;
    }
}

