/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.gpu;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.gpu.LuaImage;
import com.tom.peripherals.gpu.Triangle;
import com.tom.peripherals.gpu.Uniform;
import com.tom.peripherals.gpu.VRAM;
import com.tom.peripherals.math.MathHelper;
import com.tom.peripherals.util.IReferenceable;
import com.tom.peripherals.util.Image;
import com.tom.peripherals.util.ParamCheck;
import java.util.HashMap;
import java.util.Map;

public class TextureManager {
    private final VRAM vram;
    private Map<Integer, Texture> textureMap = new HashMap<Integer, Texture>();
    private int lastTxID = 1;
    private Texture boundTexture;
    private boolean texEnabled;

    public TextureManager(VRAM vram) {
        this.vram = vram;
    }

    public int genTextureID(Object[] a) throws LuaException {
        int c = ParamCheck.optionalInt(a, 0, 1);
        int id = this.lastTxID;
        for (int i = 0; i < c; ++i) {
            Texture t = new Texture(i + id);
            this.vram.allocEx(t, 1L);
            this.textureMap.put(i + id, t);
        }
        this.lastTxID += c;
        return id;
    }

    public int sample(double u, double v, Triangle tri, double r, double g, double b, double a) {
        Texture tx;
        Object id = tri.uniforms[Uniform.TEXTURE.ordinal()];
        Texture texture = tx = id == null ? null : this.textureMap.get((int)((Integer)id));
        if (tx == null || !this.texEnabled) {
            int ri = (int)(r * 255.0) & 0xFF;
            int gi = (int)(g * 255.0) & 0xFF;
            int bi = (int)(b * 255.0) & 0xFF;
            int ai = (int)(a * 255.0) & 0xFF;
            return ai << 24 | ri << 16 | gi << 8 | bi;
        }
        int w = tx.pixels.getWidth();
        int h = tx.pixels.getHeight();
        int iu = (int)(u * (double)w);
        int iv = (int)(v * (double)h);
        if (iu < 0) {
            iu = (int)((double)iu + Math.ceil((double)(-iu) / (double)w) * (double)w);
        }
        if (iv < 0) {
            iv = (int)((double)iv + Math.ceil((double)(-iv) / (double)h) * (double)h);
        }
        int c = tx.pixels.getRGB(iu %= w, iv %= h);
        int ri = TextureManager.colorMul(c >> 16, r);
        int gi = TextureManager.colorMul(c >> 8, g);
        int bi = TextureManager.colorMul(c, b);
        int ai = TextureManager.colorMul(c >>> 24, a);
        return ai << 24 | ri << 16 | gi << 8 | bi;
    }

    private static int colorMul(int c1, double v) {
        double c = (double)(c1 & 0xFF) / 255.0;
        double r = MathHelper.clamp(c * v, 0.0, 1.0);
        return (int)(r * 255.0);
    }

    public void deleteTextures(Object[] a) throws LuaException {
        if (a.length == 0) {
            throw new LuaException("Too few arguments: number texture ids...");
        }
        ParamCheck.ints(a, 0).forEach(t -> {
            Texture tx = this.textureMap.remove(t);
            if (tx != null) {
                this.vram.free(tx);
            }
        });
    }

    public void bindTexture(Object[] a) throws LuaException {
        if (a.length == 0) {
            throw new LuaException("Too few arguments: number id");
        }
        int id = ParamCheck.getInt(a, 0);
        this.boundTexture = this.textureMap.get(id);
    }

    public void texImage(Object[] a) throws LuaException {
        Object object;
        if (a.length < 1) {
            throw new LuaException("Too few arguments: image ref or number width, numbers texture...");
        }
        if (this.boundTexture == null) {
            throw new LuaException("No bound texture");
        }
        if (a.length == 1 && (object = a[0]) instanceof String) {
            String r = (String)object;
            IReferenceable iReferenceable = this.vram.getRefMngr().getByReference(r);
            if (!(iReferenceable instanceof LuaImage)) {
                throw new LuaException("Invalid reference");
            }
            LuaImage img = (LuaImage)iReferenceable;
            this.vram.reallocEx(this.boundTexture, img.getSize());
            this.boundTexture.pixels = new Image(img.getImage());
        } else {
            int w = ParamCheck.getInt(a, 0);
            int[] d = ParamCheck.uints(a, 1).toArray();
            int h = d.length / w;
            this.vram.reallocEx(this.boundTexture, w * h * 4);
            this.boundTexture.pixels = new Image(d, w);
        }
    }

    public int getTextureID() {
        return !this.texEnabled || this.boundTexture == null ? 0 : this.boundTexture.id;
    }

    public void setTexEnabled(boolean texEnabled) {
        this.texEnabled = texEnabled;
    }

    public static class Texture
    implements VRAM.VRAMObject {
        private final int id;
        private Image pixels;

        public Texture(int i) {
            this.id = i;
        }

        @Override
        public long getSize() {
            return this.pixels != null ? (long)(this.pixels.getWidth() * this.pixels.getHeight() * 4) : 1L;
        }
    }
}

