/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.gpu;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.api.LuaMethod;
import com.tom.peripherals.api.ReferenceableLuaObject;
import com.tom.peripherals.gpu.VRAM;
import com.tom.peripherals.util.ParamCheck;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Arrays;

public class LuaByteBuffer
extends ReferenceableLuaObject
implements VRAM.VRAMObject {
    private final VRAM mngr;
    private byte[] buf;
    private int writeIndex;
    private int readIndex;

    public LuaByteBuffer(VRAM mngr) throws LuaException {
        this(mngr, 32);
    }

    public LuaByteBuffer(VRAM mngr, int initSize) throws LuaException {
        super(mngr.getRefMngr());
        this.mngr = mngr;
        mngr.allocEx(this, initSize);
        this.buf = new byte[initSize];
    }

    @Override
    public long getSize() {
        return this.buf.length;
    }

    @LuaMethod
    public int length() {
        if (this.buf == null) {
            throw new LuaException("Error: Use after free");
        }
        return this.writeIndex;
    }

    @LuaMethod
    public int available() {
        if (this.buf == null) {
            throw new LuaException("Error: Use after free");
        }
        return this.writeIndex - this.readIndex;
    }

    @LuaMethod
    public void write(Object[] d) throws LuaException {
        if (this.buf == null) {
            throw new LuaException("Error: Use after free");
        }
        int[] dt = ParamCheck.ints(d, 0).toArray();
        if (dt.length == 0) {
            return;
        }
        this.ensureCapacity(this.writeIndex + dt.length);
        for (int i = 0; i < dt.length; ++i) {
            this.buf[this.writeIndex + i] = (byte)dt[i];
        }
        this.writeIndex += dt.length;
    }

    @LuaMethod
    public Object[] read(Object[] d) throws LuaException {
        if (this.buf == null) {
            throw new LuaException("Error: Use after free");
        }
        int amount = ParamCheck.optionalInt(d, 0, 1);
        if (amount < 0) {
            amount = this.writeIndex - this.readIndex;
        } else if (this.writeIndex - this.readIndex < amount) {
            throw new LuaException("Index out of bounds");
        }
        Object[] r = new Object[amount];
        for (int i = 0; i < amount; ++i) {
            r[i] = Byte.toUnsignedInt(this.buf[this.readIndex + i]);
        }
        this.readIndex += amount;
        return r;
    }

    private void ensureCapacity(int minCapacity) throws LuaException {
        if (minCapacity - this.buf.length > 0) {
            this.grow(minCapacity);
        }
    }

    private void grow(int minCapacity) throws LuaException {
        int oldCapacity = this.buf.length;
        int newCapacity = oldCapacity << 1;
        if (newCapacity - minCapacity < 0) {
            newCapacity = minCapacity;
        }
        this.mngr.reallocEx(this, newCapacity);
        this.buf = Arrays.copyOf(this.buf, newCapacity);
    }

    @LuaMethod
    public void free() throws LuaException {
        if (this.buf == null) {
            return;
        }
        this.mngr.getRefMngr().remove(this);
        this.mngr.free(this);
        this.buf = null;
    }

    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.ensureCapacity(this.writeIndex + len);
        System.arraycopy(b, off, this.buf, this.writeIndex, len);
        this.writeIndex += len;
    }

    public InputStream asInputStream() {
        return new InputStream(){
            int pos;
            int count;
            {
                this.pos = LuaByteBuffer.this.readIndex;
                this.count = LuaByteBuffer.this.writeIndex;
            }

            @Override
            public int read() throws IOException {
                return this.pos < this.count ? LuaByteBuffer.this.buf[this.pos++] & 0xFF : -1;
            }

            @Override
            public int read(byte[] b, int off, int len) {
                if (b == null) {
                    throw new NullPointerException();
                }
                if (off < 0 || len < 0 || len > b.length - off) {
                    throw new IndexOutOfBoundsException();
                }
                if (this.pos >= this.count) {
                    return -1;
                }
                int avail = this.count - this.pos;
                if (len > avail) {
                    len = avail;
                }
                if (len <= 0) {
                    return 0;
                }
                System.arraycopy(LuaByteBuffer.this.buf, this.pos, b, off, len);
                this.pos += len;
                return len;
            }
        };
    }

    public OutputStream asOutputStream() {
        return new OutputStream(){

            @Override
            public void write(int b) throws IOException {
                LuaByteBuffer.this.ensureCapacity(LuaByteBuffer.this.writeIndex + 1);
                LuaByteBuffer.this.buf[LuaByteBuffer.this.writeIndex] = (byte)b;
                ++LuaByteBuffer.this.writeIndex;
            }

            @Override
            public void write(byte[] b, int off, int len) {
                if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
                    throw new IndexOutOfBoundsException();
                }
                LuaByteBuffer.this.ensureCapacity(LuaByteBuffer.this.writeIndex + len);
                System.arraycopy(b, off, LuaByteBuffer.this.buf, LuaByteBuffer.this.writeIndex, len);
                LuaByteBuffer.this.writeIndex += len;
            }
        };
    }
}

