/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.gpu;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.api.LuaMethod;
import com.tom.peripherals.gpu.BaseGPU;
import com.tom.peripherals.gpu.LuaByteBuffer;
import com.tom.peripherals.gpu.LuaImage;
import com.tom.peripherals.math.Vec2i;
import com.tom.peripherals.util.IReferenceable;
import com.tom.peripherals.util.Image;
import com.tom.peripherals.util.ImageIO;
import com.tom.peripherals.util.ParamCheck;
import java.io.IOException;
import java.io.InputStream;
import java.util.function.Supplier;

public class GPUImpl
extends BaseGPU {
    public GPUImpl(BaseGPU.GPUContext ctx) {
        super(ctx);
    }

    public GPUImpl() {
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @LuaMethod
    public Object[] decodeImage(Object[] a) throws LuaException {
        Supplier<InputStream> str;
        if (a.length < 1) {
            throw new LuaException("Invalid arguments: expected buffer or unpacked numbers");
        }
        Object object = a[0];
        if (object instanceof String) {
            String r = (String)object;
            IReferenceable iReferenceable = this.ctx.getVRam().getRefMngr().getByReference(r);
            if (!(iReferenceable instanceof LuaByteBuffer)) throw new LuaException("Invalid reference");
            LuaByteBuffer buf = (LuaByteBuffer)iReferenceable;
            str = () -> buf.asInputStream();
        } else {
            int[] d = ParamCheck.ints(a, 0).toArray();
            str = () -> new IntInputStream(d);
        }
        try {
            Vec2i size = ImageIO.getSize(str.get());
            this.ctx.getVRam().checkSizeEx(size.x * size.y * 4);
            Image im = ImageIO.read(str.get());
            LuaImage i = new LuaImage(this.ctx.getVRam(), im);
            this.ctx.getVRam().alloc(i);
            return new Object[]{i};
        }
        catch (IOException e) {
            throw new LuaException(e.getMessage());
        }
    }

    @LuaMethod
    public Object[] imageFromBuffer(Object[] a) throws LuaException {
        int w = ParamCheck.getInt(a, 0);
        int[] d = ParamCheck.uints(a, 1).toArray();
        Image im = new Image(d, w);
        LuaImage i = new LuaImage(this.ctx.getVRam(), im);
        this.ctx.getVRam().allocEx(i, d.length * 4);
        return new Object[]{i};
    }

    @LuaMethod
    public Object[] newImage(Object[] a) throws LuaException {
        if (a.length > 1 && a[0] instanceof Double && a[1] instanceof Double) {
            int w = ParamCheck.getInt(a, 0);
            int h = ParamCheck.getInt(a, 1);
            if (w < 0 || h < 0) {
                throw new LuaException("Image size out of bounds");
            }
            this.ctx.getVRam().checkSizeEx(w * h * 4);
            LuaImage i = new LuaImage(this.ctx.getVRam(), new Image(w, h));
            this.ctx.getVRam().alloc(i);
            return new Object[]{i};
        }
        throw new LuaException("Invalid Arguments, excepted (number w,number h)");
    }

    @LuaMethod
    public Object[] newBuffer(Object[] a) throws LuaException {
        int init = ParamCheck.optionalInt(a, 0, 32);
        return new Object[]{new LuaByteBuffer(this.ctx.getVRam(), init)};
    }

    @LuaMethod
    public double getUsedMemory() {
        return this.ctx.getVRam().getUsedMemory();
    }

    @LuaMethod
    public double getMaxMemory() {
        return this.ctx.getVRam().getMaxMemory();
    }

    private static class IntInputStream
    extends InputStream {
        private final int[] d;
        private int i;

        public IntInputStream(int[] d) {
            this.d = d;
        }

        @Override
        public int read() throws IOException {
            return this.i >= this.d.length ? -1 : this.d[this.i++];
        }
    }
}

