/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.gpu;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.api.LuaMethod;
import com.tom.peripherals.api.TMLuaObject;
import com.tom.peripherals.gpu.GPU3D;
import com.tom.peripherals.gpu.LuaImage;
import com.tom.peripherals.gpu.Rect;
import com.tom.peripherals.gpu.VRAM;
import com.tom.peripherals.gpu.WindowGPUContext;
import com.tom.peripherals.gpu.font.Font;
import com.tom.peripherals.gpu.font.FontManager;
import com.tom.peripherals.util.IReferenceable;
import com.tom.peripherals.util.Image;
import com.tom.peripherals.util.ParamCheck;

public class BaseGPU
extends TMLuaObject {
    public Font selectedFont = FontManager.DEF;
    protected GPUContext ctx;

    public BaseGPU(GPUContext ctx) {
        this.ctx = ctx;
    }

    public BaseGPU() {
        this.ctx = (GPUContext)((Object)this);
    }

    @LuaMethod
    public boolean fill(Object[] a) throws LuaException {
        int color = a.length == 0 ? 0 : ParamCheck.toColor(a, 0);
        for (int i = 0; i < this.ctx.getWidth(); ++i) {
            for (int j = 0; j < this.ctx.getHeight(); ++j) {
                this.ctx.set(i, j, color);
            }
        }
        return true;
    }

    @LuaMethod
    public boolean filledRectangle(Object[] a) throws LuaException {
        if (a.length < 4) {
            throw new LuaException("Too few arguments (expected x,y,width,height,[color])");
        }
        int color = a.length < 5 ? 0 : ParamCheck.toColor(a, 4);
        int xStart = ParamCheck.getInt(a, 0) - 1;
        int yStart = ParamCheck.getInt(a, 1) - 1;
        int xStop = xStart + ParamCheck.getInt(a, 2);
        int yStop = yStart + ParamCheck.getInt(a, 3);
        if (xStart < this.ctx.getWidth() + 1 && yStart < this.ctx.getHeight() + 1 && xStart >= 0 && yStart >= 0) {
            xStop = xStop > this.ctx.getWidth() ? this.ctx.getWidth() : xStop;
            yStop = yStop > this.ctx.getHeight() ? this.ctx.getHeight() : yStop;
            for (int i = xStart; i < xStop; ++i) {
                for (int y = yStart; y < yStop; ++y) {
                    this.ctx.set(i, y, color);
                }
            }
            return true;
        }
        throw new LuaException("Out of boundary");
    }

    @LuaMethod
    public boolean rectangle(Object[] a) throws LuaException {
        if (a.length < 4) {
            throw new LuaException("Too few arguments (expected x,y,width,height,[color])");
        }
        int color = a.length < 5 ? 0 : ParamCheck.toColor(a, 4);
        int xStart = ParamCheck.getInt(a, 0) - 1;
        int yStart = ParamCheck.getInt(a, 1) - 1;
        int xStop = xStart + ParamCheck.getInt(a, 2);
        int yStop = yStart + ParamCheck.getInt(a, 3);
        if (xStart < this.ctx.getWidth() + 1 && yStart < this.ctx.getHeight() + 1 && xStart >= 0 && yStart >= 0) {
            xStop = xStop > this.ctx.getWidth() ? this.ctx.getWidth() : xStop;
            yStop = yStop > this.ctx.getHeight() ? this.ctx.getHeight() : yStop;
            for (int i = xStart; i < xStop; ++i) {
                for (int y = yStart; y < yStop; ++y) {
                    if (i == xStart || i == xStop - 1) {
                        this.ctx.set(i, y, color);
                        continue;
                    }
                    if (y != yStart && y != yStop - 1) continue;
                    this.ctx.set(i, y, color);
                }
            }
            return true;
        }
        throw new LuaException("Out of boundary");
    }

    @LuaMethod
    public boolean line(Object[] a) throws LuaException {
        if (a.length < 4) {
            throw new LuaException("Too few arguments (expected x1,y1,x2,y2,[color])");
        }
        int color = a.length < 5 ? 0 : ParamCheck.toColor(a, 4);
        int xStart = ParamCheck.getInt(a, 0) - 1;
        int yStart = ParamCheck.getInt(a, 1) - 1;
        int xStop = ParamCheck.getInt(a, 2) - 1;
        int yStop = ParamCheck.getInt(a, 3) - 1;
        try {
            this.line(xStart, yStart, xStop, yStop, color);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new LuaException(e.getMessage());
        }
        return true;
    }

    @LuaMethod
    public boolean lineS(Object[] a) throws LuaException {
        if (a.length < 4) {
            throw new LuaException("Too few arguments (expected x1,y1,x2,y2,[color])");
        }
        int color = a.length < 5 ? 0 : ParamCheck.toColor(a, 4);
        int xStart = ParamCheck.getInt(a, 0) - 1;
        int yStart = ParamCheck.getInt(a, 1) - 1;
        int xStop = ParamCheck.getInt(a, 2) - 1;
        int yStop = ParamCheck.getInt(a, 3) - 1;
        try {
            this.lineF(xStart, yStart, xStop, yStop, color);
        }
        catch (ArrayIndexOutOfBoundsException e) {
            throw new LuaException(e.getMessage());
        }
        return true;
    }

    public void lineF(int x0, int y0, int x1, int y1, int col) {
        if (x0 < 0 || x1 < 0 || x0 > this.ctx.getWidth() || x1 > this.ctx.getWidth()) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds: x");
        }
        if (y0 < 0 || y1 < 0 || y0 > this.ctx.getHeight() || y1 > this.ctx.getHeight()) {
            throw new ArrayIndexOutOfBoundsException("Out of bounds: y");
        }
        int dx = Math.abs(x1 - x0);
        int dy = Math.abs(y1 - y0);
        int sgnX = x0 < x1 ? 1 : -1;
        int sgnY = y0 < y1 ? 1 : -1;
        int e = 0;
        for (int i = 0; i < dx + dy; ++i) {
            this.ctx.set(x0, y0, col);
            int e1 = e + dy;
            int e2 = e - dx;
            if (Math.abs(e1) < Math.abs(e2)) {
                x0 += sgnX;
                e = e1;
                continue;
            }
            y0 += sgnY;
            e = e2;
        }
    }

    public void line(int x0, int y0, int x1, int y1, int col) {
        int dx = Math.abs(x1 - x0);
        int sx = x0 < x1 ? 1 : -1;
        int dy = -Math.abs(y1 - y0);
        int sy = y0 < y1 ? 1 : -1;
        int err = dx + dy;
        while (true) {
            this.ctx.set(x0, y0, col);
            if (x0 == x1 && y0 == y1) break;
            int e2 = 2 * err;
            if (e2 >= dy) {
                err += dy;
                x0 += sx;
            }
            if (e2 > dx) continue;
            err += dx;
            y0 += sy;
        }
    }

    @LuaMethod
    public Object[] getSize() {
        return new Object[]{this.ctx.getWidth(), this.ctx.getHeight()};
    }

    @LuaMethod
    public boolean drawText(Object[] a) throws LuaException {
        if (a.length < 3) {
            throw new LuaException("Too few arguments, excepted (number x,number y,String text, [number text_color], [number bg_color], [number size], [number padding])");
        }
        if (a.length > 2 && a[0] instanceof Double && a[1] instanceof Double && a[2] != null) {
            int x = ParamCheck.getInt(a, 0) - 1;
            int y = ParamCheck.getInt(a, 1) - 1;
            int c = ParamCheck.optionalInt(a, 3, -1);
            int bg = ParamCheck.optionalInt(a, 4, -1);
            int size = ParamCheck.optionalInt(a, 5, 1);
            int padding = ParamCheck.optionalInt(a, 6, 1);
            String s = ParamCheck.getString(a, 2);
            char[] chars = s.toCharArray();
            int l = this.getTextLength(chars, size, padding);
            if (x < 0 || l + x > this.ctx.getWidth()) {
                throw new LuaException("Out of boundary x " + x + ":" + (l + x));
            }
            if (y < 0 || y + this.selectedFont.fontHeight > this.ctx.getHeight()) {
                throw new LuaException("Out of boundary y");
            }
            int wx = x;
            try {
                for (int i = 0; i < chars.length; ++i) {
                    int k;
                    int j;
                    char d = chars[i];
                    int index = this.selectedFont.chars2.indexOf(d);
                    if (index == -1) {
                        index = this.selectedFont.UNKNOWN;
                    }
                    int[] charData = this.selectedFont.chars[index];
                    int w = this.selectedFont.widths[index];
                    if (d == ' ') {
                        w = 5;
                        if (bg > -1) {
                            for (j = 0; j < charData.length; ++j) {
                                for (k = 0; k < w; ++k) {
                                    this.fill(wx, k, y, j, size, bg);
                                }
                            }
                        }
                    } else {
                        for (j = 0; j < charData.length; ++j) {
                            int b = charData[j];
                            for (int k2 = 0; k2 < w; ++k2) {
                                if ((b & 1 << k2) != 0) {
                                    this.fill(wx, k2, y, j, size, c);
                                    continue;
                                }
                                if (bg <= -1) continue;
                                this.fill(wx, k2, y, j, size, bg);
                            }
                        }
                    }
                    if (bg > -1) {
                        for (j = 0; j < charData.length; ++j) {
                            for (k = 0; k < padding; ++k) {
                                this.fill(wx, w + k, y, j, size, bg);
                            }
                        }
                    }
                    wx += (w + padding) * size;
                }
            }
            catch (IndexOutOfBoundsException e) {
                e.printStackTrace();
            }
            return true;
        }
        throw new LuaException("Invalid Arguments, excepted (number x,number y,String text, [number text_color], [number bg_color], [number size], [number padding])");
    }

    @LuaMethod
    public Object[] getFont() {
        return new Object[]{this.selectedFont.name, this.selectedFont.editable()};
    }

    @LuaMethod
    public boolean setFont(Object[] a) throws LuaException {
        if (a.length > 0) {
            Font f = FontManager.getOrLoadFont(this.ctx.getVRam().getIntFonts(), ParamCheck.getString(a, 0));
            if (f != null) {
                this.selectedFont = f;
            }
            return true;
        }
        throw new LuaException("Invalid Arguments, excepted (string font_name)");
    }

    @LuaMethod
    public int getTextLength(Object[] a) throws LuaException {
        if (a.length > 0 && a[0] != null) {
            int size = ParamCheck.optionalInt(a, 1, 1);
            int padding = ParamCheck.optionalInt(a, 2, 1);
            return this.getTextLength(a[0].toString().toCharArray(), size, padding);
        }
        throw new LuaException("Invalid Arguments, excepted (string text, [number size], [number padding])");
    }

    @LuaMethod
    public boolean drawTextSmart(Object[] a) throws LuaException {
        if (a.length < 3) {
            throw new LuaException("Too few arguments, excepted (number x,number y,String text, [number text_color], [number bg_color], [boolean force_unicode], [number size], [number padding])");
        }
        int x = ParamCheck.getInt(a, 0) - 1;
        int y = ParamCheck.getInt(a, 1) - 1;
        int c = ParamCheck.optionalInt(a, 3, -1);
        int bg = ParamCheck.optionalInt(a, 4, -1);
        boolean force_unicode = a.length > 5 && a[5] instanceof Boolean ? (Boolean)a[5] : false;
        int sizeIn = ParamCheck.optionalInt(a, 6, 1);
        int padding = ParamCheck.optionalInt(a, 7, 1);
        String s = ParamCheck.getString(a, 2);
        char[] chars = s.toCharArray();
        int l = this.getTextLength(chars, sizeIn, padding);
        if (x < 0 || l + x > this.ctx.getWidth()) {
            throw new LuaException("Out of boundary x");
        }
        if (y < 0 || y + this.selectedFont.fontHeight > this.ctx.getHeight()) {
            throw new LuaException("Out of boundary y");
        }
        int wx = x;
        String font = this.selectedFont.name;
        try {
            for (int i = 0; i < chars.length; ++i) {
                int k;
                int j;
                int size = sizeIn;
                char d = chars[i];
                if (!force_unicode && d < '\u0100') {
                    size *= 2;
                    this.selectedFont = FontManager.getOrLoadFont(this.ctx.getVRam().getIntFonts(), "ascii");
                } else {
                    this.selectedFont = FontManager.getOrLoadFont(this.ctx.getVRam().getIntFonts(), String.format("unicode_page_%02x", d / 256));
                }
                int index = this.selectedFont.chars2.indexOf(d);
                if (index == -1) {
                    index = this.selectedFont.UNKNOWN;
                }
                int[] charData = this.selectedFont.chars[index];
                int w = this.selectedFont.widths[index];
                if (d == ' ') {
                    w = 5;
                    if (bg > -1) {
                        for (j = 0; j < charData.length; ++j) {
                            for (k = 0; k < w; ++k) {
                                this.fill(wx, k, y, j, size, bg);
                            }
                        }
                    }
                } else {
                    for (j = 0; j < charData.length; ++j) {
                        int b = charData[j];
                        for (int k2 = 0; k2 < w; ++k2) {
                            if ((b & 1 << k2) != 0) {
                                this.fill(wx, k2, y, j, size, c);
                                continue;
                            }
                            if (bg <= -1) continue;
                            this.fill(wx, k2, y, j, size, bg);
                        }
                    }
                }
                if (bg > -1) {
                    for (j = 0; j < charData.length; ++j) {
                        for (k = 0; k < padding; ++k) {
                            this.fill(wx, w + k, y, j, size, bg);
                        }
                    }
                }
                wx += (w + padding) * size;
            }
        }
        catch (IndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        this.selectedFont = FontManager.getOrLoadFont(this.ctx.getVRam().getIntFonts(), font);
        return true;
    }

    @LuaMethod
    public boolean setFontDefaultCharID(Object[] a) throws LuaException {
        if (!this.selectedFont.editable()) {
            throw new LuaException("Selected font is not modifiable");
        }
        if (a.length > 0) {
            int id = ParamCheck.getInt(a, 0) - 1;
            if (id < 0) {
                throw new LuaException("Bad Argument #1, (too small number (" + id + ") minimum value is 1 )");
            }
            if (id > 255) {
                throw new LuaException("Bad Argument #1, (too big number (" + id + ") maximum value is 256 )");
            }
            this.selectedFont.UNKNOWN = id;
            return true;
        }
        throw new LuaException("Invalid Arguments, excepted (number id)");
    }

    @LuaMethod
    public int getFontDefaultCharID() {
        return this.selectedFont.UNKNOWN;
    }

    @LuaMethod
    public int addNewChar(Object[] a) throws LuaException {
        if (!this.selectedFont.editable()) {
            throw new LuaException("Selected font is not modifiable");
        }
        if (a.length > 17) {
            String c = ParamCheck.getString(a, 0);
            if (c.length() != 1) {
                throw new LuaException("Bad Argument #1 a sigle character expected");
            }
            int[] d = ParamCheck.ints(a, 1).toArray();
            if (d.length != 17) {
                throw new LuaException("Invalid arguments, expected (string char, number width, 16 x number char_data)");
            }
            return this.selectedFont.addChar(c, d);
        }
        throw new LuaException("Invalid arguments, expected (string char, number width, 16 x number char_data)");
    }

    @LuaMethod
    public boolean delChar(Object[] a) throws LuaException {
        if (!this.selectedFont.editable()) {
            throw new LuaException("Selected font is not modifiable");
        }
        if (a.length > 0 && a[0] != null) {
            String c = ParamCheck.getString(a, 0);
            if (c.length() != 1) {
                throw new LuaException("Bad Argument #1 a sigle character expected");
            }
            this.selectedFont.remove(c);
            return true;
        }
        throw new LuaException("Invalid arguments, expected (string char)");
    }

    @LuaMethod
    public int freeChars() {
        return this.selectedFont.freeChars();
    }

    @LuaMethod
    public boolean clearChars() throws LuaException {
        this.selectedFont.clear();
        return true;
    }

    @LuaMethod
    public boolean drawChar(Object[] a) throws LuaException {
        if (a.length < 3) {
            throw new LuaException("Too few arguments, excepted (number x,number y,number char, [number text_color], [number bg_color], [number size])");
        }
        int x = ParamCheck.getInt(a, 0) - 1;
        int y = ParamCheck.getInt(a, 1) - 1;
        int index = ParamCheck.getInt(a, 2) - 1;
        int c = ParamCheck.optionalInt(a, 3, -1);
        int bg = ParamCheck.optionalInt(a, 4, -1);
        int size = ParamCheck.optionalInt(a, 5, 1);
        if (index == -1) {
            index = this.selectedFont.UNKNOWN;
        }
        int[] charData = this.selectedFont.chars[index];
        int w = this.selectedFont.widths[index];
        if (x < 0 || w * size + x > this.ctx.getWidth()) {
            throw new LuaException("Out of boundary x");
        }
        if (y < 0 || y + charData.length / w * size > this.ctx.getHeight()) {
            throw new LuaException("Out of boundary y");
        }
        for (int j = 0; j < charData.length; ++j) {
            int b = charData[j];
            for (int k = 0; k < w; ++k) {
                if ((b & 1 << k) != 0) {
                    this.fill(x, k, y, j, size, c);
                    continue;
                }
                if (bg <= -1) continue;
                this.fill(x, k, y, j, size, bg);
            }
        }
        return true;
    }

    @LuaMethod
    public boolean drawBuffer(Object[] a) throws LuaException {
        if (a.length < 4) {
            throw new LuaException("Too few arguments, excepted (number x,number y,number w, number scale, number... data)");
        }
        int x = ParamCheck.getInt(a, 0) - 1;
        int y = ParamCheck.getInt(a, 1) - 1;
        int w = ParamCheck.getInt(a, 2);
        int s = ParamCheck.getInt(a, 3);
        int[] d = ParamCheck.uints(a, 4).toArray();
        if (x < 0 || w * s + x > this.ctx.getWidth()) {
            throw new LuaException("Out of boundary x");
        }
        if (y < 0 || y + d.length / w * s > this.ctx.getHeight()) {
            throw new LuaException("Out of boundary y");
        }
        for (int i = 0; i < d.length; ++i) {
            this.fill(x, i % w, y, i / w, s, d[i]);
        }
        return true;
    }

    @LuaMethod
    public boolean drawImage(Object[] a) throws LuaException {
        if (a.length < 3) {
            throw new LuaException("Too few arguments, excepted (number x, number y, image ref)");
        }
        int xS = ParamCheck.getInt(a, 0) - 1;
        int yS = ParamCheck.getInt(a, 1) - 1;
        IReferenceable iReferenceable = this.ctx.getVRam().getRefMngr().getByReference(ParamCheck.getString(a, 2));
        if (!(iReferenceable instanceof LuaImage)) {
            throw new LuaException("Invalid reference");
        }
        LuaImage li = (LuaImage)iReferenceable;
        Image img = li.getImage();
        int cW = this.ctx.getWidth();
        int cH = this.ctx.getHeight();
        int iW = img.getWidth();
        int iH = img.getHeight();
        for (int x = Math.max(0, -xS); x < iW && x + xS < cW; ++x) {
            for (int y = Math.max(0, -yS); y < iH && y + yS < cH; ++y) {
                this.ctx.set(x + xS, y + yS, img.getRGB(x, y));
            }
        }
        return true;
    }

    @LuaMethod
    public void sync() throws LuaException {
        this.ctx.sync();
    }

    @LuaMethod
    public Object getBounds() throws LuaException {
        return this.ctx.getBounds();
    }

    private void fill(int x, int ox, int y, int oy, int size, int col) {
        for (int i = 0; i < size; ++i) {
            for (int j = 0; j < size; ++j) {
                this.ctx.set(x + ox * size + i, y + oy * size + j, col);
            }
        }
    }

    private int getTextLength(char[] chars, int size, int padding) {
        int l = 0;
        for (int i = 0; i < chars.length; ++i) {
            char d = chars[i];
            int index = this.selectedFont.chars2.indexOf(d);
            if (index == -1) {
                index = this.selectedFont.UNKNOWN;
            }
            int w = this.selectedFont.widths[index];
            if (d == ' ') {
                w = 5;
            }
            l += (w + padding) * size;
        }
        return l;
    }

    @LuaMethod
    public Object createWindow(Object[] a) throws LuaException {
        Rect r = Rect.parseRect(a);
        return new BaseGPU(new WindowGPUContext(this.ctx, r));
    }

    @LuaMethod
    public Object createWindow3D(Object[] a) throws LuaException {
        Rect r = Rect.parseRect(a);
        return new GPU3D(new WindowGPUContext(this.ctx, r));
    }

    public static interface GPUContext {
        public void set(int var1, int var2, int var3);

        public void sync() throws LuaException;

        public VRAM getVRam();

        public int getWidth();

        public int getHeight();

        default public Rect getBounds() {
            return new Rect(this.getWidth(), this.getHeight());
        }
    }
}

