/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block.entity;

import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.api.LuaMethod;
import com.tom.peripherals.api.ObjectWrapper;
import com.tom.peripherals.api.TMLuaObject;
import com.tom.peripherals.platform.AbstractPeripheralBlockEntity;
import com.tom.peripherals.util.TickerUtil;
import dan200.computercraft.impl.BundledRedstone;
import dan200.computercraft.shared.util.DirectionUtil;
import dan200.computercraft.shared.util.RedstoneUtil;
import java.util.Arrays;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3532;

public class RedstonePortBlockEntity
extends AbstractPeripheralBlockEntity
implements TickerUtil.TickableServer {
    private static final Object[] SIDES = Arrays.stream(class_2350.values()).map(e -> e.method_15434()).toArray();
    private ObjectWrapper peripheral;
    private boolean internalOutputChanged = false;
    private final int[] internalOutput = new int[6];
    private final int[] internalBundledOutput = new int[6];
    private final int[] externalOutput = new int[6];
    private final int[] externalBundledOutput = new int[6];
    private boolean inputChanged = false;
    private final int[] input = new int[6];
    private final int[] bundledInput = new int[6];

    public RedstonePortBlockEntity(class_2591<?> p_155228_, class_2338 p_155229_, class_2680 p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    @Override
    public ObjectWrapper getPeripheral() {
        if (this.peripheral == null) {
            this.peripheral = new ObjectWrapper("tm_rsPort", new RSPort());
        }
        return this.peripheral;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateOutput() {
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            if (!this.internalOutputChanged) {
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return false;
            }
            boolean changed = false;
            for (int i = 0; i < 6; ++i) {
                if (this.externalOutput[i] != this.internalOutput[i]) {
                    this.externalOutput[i] = this.internalOutput[i];
                    changed = true;
                }
                if (this.externalBundledOutput[i] == this.internalBundledOutput[i]) continue;
                this.externalBundledOutput[i] = this.internalBundledOutput[i];
                changed = true;
            }
            this.internalOutputChanged = false;
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return changed;
        }
    }

    @Override
    public void updateServer() {
        if (this.inputChanged) {
            this.inputChanged = false;
            this.getPeripheral().queueEvent("tm_redstone", new Object[0]);
        }
        if (this.updateOutput()) {
            for (class_2350 dir : DirectionUtil.FACINGS) {
                RedstoneUtil.propagateRedstoneOutput((class_1937)this.method_10997(), (class_2338)this.method_11016(), (class_2350)dir);
            }
            this.updateRedstoneInputs();
        }
    }

    public int getInput(class_2350 side) {
        return this.input[side.ordinal()];
    }

    public int getBundledInput(class_2350 side) {
        return this.bundledInput[side.ordinal()];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setOutput(class_2350 side, int output) {
        int index = side.ordinal();
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            if (this.internalOutput[index] != output) {
                this.internalOutput[index] = output;
                this.internalOutputChanged = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getOutput(class_2350 side) {
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.internalOutput[side.ordinal()];
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setBundledOutput(class_2350 side, int output) {
        int index = side.ordinal();
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            if (this.internalBundledOutput[index] != output) {
                this.internalBundledOutput[index] = output;
                this.internalOutputChanged = true;
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int getBundledOutput(class_2350 side) {
        int[] nArray = this.internalOutput;
        synchronized (this.internalOutput) {
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return this.internalBundledOutput[side.ordinal()];
        }
    }

    public int getExternalRedstoneOutput(class_2350 side) {
        return this.externalOutput[side.ordinal()];
    }

    public int getExternalBundledRedstoneOutput(class_2350 side) {
        return this.externalBundledOutput[side.ordinal()];
    }

    public void setRedstoneInput(class_2350 side, int level) {
        int index = side.ordinal();
        if (this.input[index] != level) {
            this.input[index] = level;
            this.inputChanged = true;
        }
    }

    public void setBundledRedstoneInput(class_2350 side, int combination) {
        int index = side.ordinal();
        if (this.bundledInput[index] != combination) {
            this.bundledInput[index] = combination;
            this.inputChanged = true;
        }
    }

    private void updateRedstoneInput(class_2350 dir, class_2338 targetPos) {
        class_2350 offsetSide = dir.method_10153();
        this.setRedstoneInput(dir, RedstoneUtil.getRedstoneInput((class_1937)this.field_11863, (class_2338)targetPos, (class_2350)dir));
        this.setBundledRedstoneInput(dir, BundledRedstone.getOutput((class_1937)this.method_10997(), (class_2338)targetPos, (class_2350)offsetSide));
    }

    private void updateRedstoneInputs() {
        class_2338 pos = this.method_11016();
        for (class_2350 dir : DirectionUtil.FACINGS) {
            this.updateRedstoneInput(dir, pos.method_10093(dir));
        }
    }

    public void neighborChanged(class_2338 neighbour) {
        this.updateInputAt(neighbour);
    }

    private void updateInputAt(class_2338 neighbour) {
        for (class_2350 dir : DirectionUtil.FACINGS) {
            class_2338 offset = this.method_11016().method_10093(dir);
            if (!offset.equals((Object)neighbour)) continue;
            this.updateRedstoneInput(dir, offset);
            return;
        }
        this.updateRedstoneInputs();
    }

    public class RSPort
    extends TMLuaObject {
        @LuaMethod
        public Object[] getSides() throws LuaException {
            return SIDES;
        }

        @LuaMethod
        public boolean getInput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getInput(this.getDir(args[0])) > 0;
        }

        @LuaMethod
        public int getAnalogInput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getInput(this.getDir(args[0]));
        }

        @LuaMethod
        public int getAnalogueInput(Object[] args) throws LuaException {
            return this.getAnalogInput(args);
        }

        @LuaMethod
        public int getBundledInput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getBundledInput(this.getDir(args[0]));
        }

        @LuaMethod
        public boolean getOutput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getOutput(this.getDir(args[0])) > 0;
        }

        @LuaMethod
        public int getAnalogOutput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getOutput(this.getDir(args[0]));
        }

        @LuaMethod
        public int getAnalogueOutput(Object[] args) throws LuaException {
            return this.getAnalogOutput(args);
        }

        @LuaMethod
        public int getBundledOutput(Object[] args) throws LuaException {
            if (args.length < 1) {
                throw new LuaException("Too few arguments (expected direction)");
            }
            return RedstonePortBlockEntity.this.getBundledOutput(this.getDir(args[0]));
        }

        @LuaMethod
        public void setOutput(Object[] args) throws LuaException {
            if (args.length < 2) {
                throw new LuaException("Too few arguments (expected direction, value)");
            }
            Object object = args[1];
            if (!(object instanceof Boolean)) {
                throw new LuaException("Bad argument #2 (expected Boolean)");
            }
            Boolean v = (Boolean)object;
            RedstonePortBlockEntity.this.setOutput(this.getDir(args[0]), v != false ? 15 : 0);
        }

        @LuaMethod
        public void setAnalogOutput(Object[] args) throws LuaException {
            if (args.length < 2) {
                throw new LuaException("Too few arguments (expected direction, value)");
            }
            Object object = args[1];
            if (!(object instanceof Double)) {
                throw new LuaException("Bad argument #2 (expected Number)");
            }
            Double v = (Double)object;
            class_2350 dir = this.getDir(args[0]);
            int out = class_3532.method_15357((double)v);
            if (out < 0 || out > 15) {
                throw new LuaException("Bad argument #2: Expected number in range 0-15");
            }
            RedstonePortBlockEntity.this.setOutput(dir, out);
        }

        @LuaMethod
        public void setAnalogueOutput(Object[] args) throws LuaException {
            this.setAnalogOutput(args);
        }

        @LuaMethod
        public void setBundledOutput(Object[] args) throws LuaException {
            if (args.length < 2) {
                throw new LuaException("Too few arguments (expected direction, value)");
            }
            Object object = args[1];
            if (!(object instanceof Double)) {
                throw new LuaException("Bad argument #2 (expected Number)");
            }
            Double v = (Double)object;
            class_2350 dir = this.getDir(args[0]);
            int out = class_3532.method_15357((double)v);
            RedstonePortBlockEntity.this.setBundledOutput(dir, out);
        }

        @LuaMethod
        public boolean testBundledInput(Object[] args) throws LuaException {
            if (args.length < 2) {
                throw new LuaException("Too few arguments (expected direction, mask)");
            }
            Object object = args[1];
            if (!(object instanceof Double)) {
                throw new LuaException("Bad argument #2 (expected Number)");
            }
            Double md = (Double)object;
            int value = RedstonePortBlockEntity.this.getBundledInput(this.getDir(args[0]));
            int mask = class_3532.method_15357((double)md);
            return (value & mask) == mask;
        }

        private class_2350 getDir(Object in) throws LuaException {
            String side = String.valueOf(in);
            class_2350 dir = null;
            for (class_2350 d : class_2350.values()) {
                if (!d.method_10151().equalsIgnoreCase(side)) continue;
                dir = d;
                break;
            }
            if (dir == null) {
                throw new LuaException("Bad argument #1: expected one of: up, down, north, south, east, west");
            }
            return dir;
        }
    }
}

