/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block.entity;

import com.tom.peripherals.Content;
import com.tom.peripherals.api.IComputer;
import com.tom.peripherals.api.ITMPeripheral;
import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.menu.KeyboardMenu;
import com.tom.peripherals.platform.AbstractPeripheralBlockEntity;
import com.tom.peripherals.util.ParamCheck;
import java.lang.invoke.LambdaMetafactory;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Function;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2561;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3908;

public class KeyboardBlockEntity
extends AbstractPeripheralBlockEntity
implements class_3908 {
    private Peripheral per;

    public KeyboardBlockEntity(class_2591<?> p_155228_, class_2338 p_155229_, class_2680 p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    @Override
    public Peripheral getPeripheral() {
        if (this.per == null) {
            this.per = new Peripheral();
        }
        return this.per;
    }

    public class_1703 createMenu(int p_39954_, class_1661 p_39955_, class_1657 p_39956_) {
        return new KeyboardMenu(p_39954_, p_39955_, this);
    }

    public class_2561 method_5476() {
        return class_2561.method_43473();
    }

    public void queueEvent(String event, Object[] args) {
        this.getPeripheral().queueEvent(event, args);
    }

    public void onKeyboardOpen(int id) {
        if (this.method_11010().method_27852((class_2248)Content.keyboard_dongle.get())) {
            this.queueEvent("portable_connect", new Object[]{id});
        }
    }

    public void onKeyboardClosed(int id) {
        if (this.method_11010().method_27852((class_2248)Content.keyboard_dongle.get())) {
            this.queueEvent("portable_disconnect", new Object[]{id});
        }
    }

    public boolean menuStillValid(class_1657 player) {
        if (this.method_11010().method_27852((class_2248)Content.keyboard_dongle.get())) {
            return this.field_11867.method_10262((class_2382)player.method_24515()) < 4096.0;
        }
        return this.field_11867.method_10262((class_2382)player.method_24515()) < 256.0;
    }

    private class Peripheral
    implements ITMPeripheral {
        private static final String[] METHODS = new String[]{"setFireNativeEvents"};
        private Map<IComputer, CompSettings> computers = new ConcurrentHashMap<IComputer, CompSettings>();

        private Peripheral() {
        }

        @Override
        public String getType() {
            return "tm_keyboard";
        }

        @Override
        public String[] getMethodNames() {
            return METHODS;
        }

        @Override
        public Object[] call(IComputer computer, String method, Object[] args) throws LuaException {
            if (method.equals("setFireNativeEvents")) {
                boolean v;
                this.computers.computeIfAbsent((IComputer)computer, (Function<IComputer, CompSettings>)LambdaMetafactory.metafactory(null, null, null, (Ljava/lang/Object;)Ljava/lang/Object;, lambda$call$0(com.tom.peripherals.api.IComputer ), (Lcom/tom/peripherals/api/IComputer;)Lcom/tom/peripherals/block/entity/KeyboardBlockEntity$CompSettings;)()).fireNativeEvents = v = ParamCheck.getBoolean(args, 0);
            }
            return null;
        }

        @Override
        public void attach(IComputer computer) {
            this.computers.put(computer, new CompSettings());
        }

        @Override
        public void detach(IComputer computer) {
            this.computers.remove(computer);
        }

        public void queueEvent(String event, Object[] args) {
            Object[] a = new Object[args.length + 1];
            for (int i = 0; i < args.length; ++i) {
                a[i + 1] = args[i];
            }
            for (Map.Entry<IComputer, CompSettings> c : this.computers.entrySet()) {
                if (c.getValue().fireNativeEvents) {
                    c.getKey().queueEvent(event, args);
                    continue;
                }
                a[0] = c.getKey().getAttachmentName();
                c.getKey().queueEvent("tm_keyboard_" + event, a);
            }
        }

        private static /* synthetic */ CompSettings lambda$call$0(IComputer __) {
            return new CompSettings();
        }
    }

    private static class CompSettings {
        private boolean fireNativeEvents;

        private CompSettings() {
        }
    }
}

