/*
 * Decompiled with CFR 0.152.
 */
package com.tom.peripherals.block.entity;

import com.tom.peripherals.Config;
import com.tom.peripherals.api.IComputer;
import com.tom.peripherals.api.ITMPeripheral;
import com.tom.peripherals.api.LuaException;
import com.tom.peripherals.api.LuaMethod;
import com.tom.peripherals.block.entity.MonitorBlockEntity;
import com.tom.peripherals.gpu.BaseGPU;
import com.tom.peripherals.gpu.GPUImpl;
import com.tom.peripherals.gpu.VRAM;
import com.tom.peripherals.math.Vec2i;
import com.tom.peripherals.platform.AbstractPeripheralBlockEntity;
import com.tom.peripherals.platform.Platform;
import com.tom.peripherals.util.ParamCheck;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Stack;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3738;

public class GPUBlockEntity
extends AbstractPeripheralBlockEntity {
    private GPUPeripheral peripheral;

    public GPUBlockEntity(class_2591<?> p_155228_, class_2338 p_155229_, class_2680 p_155230_) {
        super(p_155228_, p_155229_, p_155230_);
    }

    @Override
    public GPUPeripheral getPeripheral() {
        if (this.peripheral == null) {
            this.peripheral = new GPUPeripheral();
        }
        return this.peripheral;
    }

    public void monitorClick(MonitorBlockEntity be, int x, int y, boolean soft) {
        this.getPeripheral().monitorClick(be, x, y, soft);
    }

    public void monitorEvent(MonitorBlockEntity be, String ev, int x, int y, Integer param) {
        this.getPeripheral().monitorEvent(be, ev, x, y, param);
    }

    private class GPUPeripheral
    implements ITMPeripheral,
    BaseGPU.GPUContext,
    VRAM.VRAMObject {
        private List<List<MonitorBlockEntity>> monitors;
        private List<IComputer> computers = new ArrayList<IComputer>();
        private int syncState = 0;
        private int maxX = 0;
        private int maxY = 0;
        private int size = 16;
        private int[][] screen = new int[16][16];
        private int error = 0;
        private GPUImpl impl = new GPUExt(this);
        private VRAM vram = new VRAM(0x1000000L);

        public GPUPeripheral() {
            this.vram.alloc(this);
        }

        @Override
        public String getType() {
            return "tm_gpu";
        }

        @Override
        public String[] getMethodNames() {
            return this.impl.getMethodNames();
        }

        @Override
        public Object[] call(IComputer computer, String method, Object[] args) throws LuaException {
            switch (this.error) {
                case 1: {
                    throw new LuaException("Attached screen too big");
                }
                case 2: {
                    throw new LuaException("Not enough VRAM for screen buffer");
                }
            }
            try {
                return this.impl.callInt(computer, method, args);
            }
            catch (NoSuchMethodException e) {
                throw new LuaException("No such method");
            }
        }

        @Override
        public void attach(IComputer computer) {
            this.computers.add(computer);
        }

        @Override
        public void detach(IComputer computer) {
            this.computers.remove(computer);
        }

        @Override
        public void set(int x, int y, int c) {
            this.screen[x][y] = Integer.reverseBytes(c) >> 8 | 0xFF000000;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void sync() {
            boolean exec = false;
            GPUPeripheral gPUPeripheral = this;
            synchronized (gPUPeripheral) {
                if (this.syncState == 0) {
                    this.syncState = 1;
                    exec = true;
                } else {
                    this.syncState = 2;
                }
            }
            if (exec) {
                Platform.getServer().execute(this::sync0);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void sync0() {
            int index1 = 0;
            for (List<MonitorBlockEntity> cMonList : this.getMonitors(false)) {
                int index2 = cMonList.size() - 1;
                for (MonitorBlockEntity mon : cMonList) {
                    int[] s = mon.screen;
                    mon.screen = GPUPeripheral.separateIntArray(this.screen, index1, index2, this.size);
                    mon.width = this.size;
                    if (!Arrays.equals(s, mon.screen)) {
                        mon.sync();
                    }
                    --index2;
                }
                ++index1;
            }
            boolean exec = false;
            GPUPeripheral gPUPeripheral = this;
            synchronized (gPUPeripheral) {
                if (this.syncState != 1) {
                    this.syncState = 1;
                    exec = true;
                } else {
                    this.syncState = 0;
                }
            }
            if (exec) {
                Platform.getServer().method_18858((Runnable)new class_3738(Platform.getServer().method_3780() + 1, this::sync0));
            }
        }

        public MonitorBlockEntity findMonitor() {
            for (class_2350 f : class_2350.values()) {
                if (f.method_10166() == class_2350.class_2351.field_11052) continue;
                class_2338 p = GPUBlockEntity.this.field_11867.method_10093(f);
                class_2586 class_25862 = GPUBlockEntity.this.field_11863.method_8321(p);
                if (!(class_25862 instanceof MonitorBlockEntity)) continue;
                MonitorBlockEntity m = (MonitorBlockEntity)class_25862;
                return m;
            }
            return null;
        }

        public List<List<MonitorBlockEntity>> connectMonitors(MonitorBlockEntity base) {
            this.error = 0;
            if (base != null) {
                List<MonitorBlockEntity> cMons;
                List<MonitorBlockEntity> listX = this.getMonitorsRight(base);
                ArrayList<List<MonitorBlockEntity>> mons = new ArrayList<List<MonitorBlockEntity>>();
                List<MonitorBlockEntity> listBY = this.getMonitorsUp(base);
                int maxSizeY = listBY.size() + 1;
                int maxSizeX = listX.size() + 1;
                for (MonitorBlockEntity mon : listX) {
                    cMons = this.getMonitorsUp(mon);
                    maxSizeY = Math.min(maxSizeY, cMons.size());
                }
                for (MonitorBlockEntity mon : listBY) {
                    cMons = this.getMonitorsRight(mon);
                    maxSizeX = Math.min(maxSizeX, cMons.size());
                }
                if (maxSizeX > Config.maxScreenSize || maxSizeY > Config.maxScreenSize) {
                    this.error = 1;
                    return Collections.emptyList();
                }
                for (int x = 0; x < maxSizeX; ++x) {
                    ArrayList<MonitorBlockEntity> cM = new ArrayList<MonitorBlockEntity>();
                    for (int y = 0; y < maxSizeY; ++y) {
                        cM.add(((MonitorBlockEntity)GPUBlockEntity.this.field_11863.method_8321(base.getOffset(x, y, base.getDirection()))).connect(GPUBlockEntity.this.field_11867));
                    }
                    mons.add(cM);
                }
                int oldX = this.maxX;
                int oldY = this.maxY;
                this.maxX = maxSizeX;
                this.maxY = maxSizeY;
                if (oldX != this.maxX || oldY != this.maxY) {
                    int newSize = this.maxX * this.size * this.maxY * this.size * 4;
                    if (this.vram.realloc(this, newSize)) {
                        this.screen = new int[this.maxX * this.size][this.maxY * this.size];
                    } else {
                        this.error = 2;
                        return Collections.emptyList();
                    }
                }
                return mons;
            }
            return Collections.emptyList();
        }

        public List<MonitorBlockEntity> getMonitorsUp(MonitorBlockEntity master) {
            ArrayList<MonitorBlockEntity> connectedMonitors = new ArrayList<MonitorBlockEntity>();
            if (master != null) {
                Stack<MonitorBlockEntity> traversingMonitors = new Stack<MonitorBlockEntity>();
                traversingMonitors.add(master);
                class_2350 direction = master.getDirection();
                int i = 1;
                while (!traversingMonitors.isEmpty()) {
                    MonitorBlockEntity m;
                    MonitorBlockEntity storage = (MonitorBlockEntity)((Object)traversingMonitors.pop());
                    connectedMonitors.add(storage);
                    class_2586 te = GPUBlockEntity.this.field_11863.method_8321(master.getOffset(0, i, direction));
                    if (!(te instanceof MonitorBlockEntity) || connectedMonitors.contains((Object)(m = (MonitorBlockEntity)te)) || m.getDirection() != direction) break;
                    traversingMonitors.add(m);
                    ++i;
                }
            }
            return connectedMonitors;
        }

        public List<MonitorBlockEntity> getMonitorsRight(MonitorBlockEntity master) {
            ArrayList<MonitorBlockEntity> connectedMonitors = new ArrayList<MonitorBlockEntity>();
            if (master != null) {
                Stack<MonitorBlockEntity> traversingMonitors = new Stack<MonitorBlockEntity>();
                traversingMonitors.add(master);
                class_2350 direction = master.getDirection();
                int i = 1;
                while (!traversingMonitors.isEmpty()) {
                    MonitorBlockEntity m;
                    MonitorBlockEntity storage = (MonitorBlockEntity)((Object)traversingMonitors.pop());
                    connectedMonitors.add(storage);
                    class_2586 te = GPUBlockEntity.this.field_11863.method_8321(master.getOffset(i, 0, direction));
                    if (!(te instanceof MonitorBlockEntity) || connectedMonitors.contains((Object)(m = (MonitorBlockEntity)te)) || m.getDirection() != direction) break;
                    traversingMonitors.add(m);
                    ++i;
                }
            }
            return connectedMonitors;
        }

        public static int[] separateIntArray(int[][] in, int index1, int index2, int size) {
            int[] ret = new int[size * size];
            try {
                int indexStart1 = index1 * size;
                int indexStart2 = index2 * size;
                int indexEnd1 = (index1 + 1) * size;
                int indexEnd2 = (index2 + 1) * size;
                int i2 = 0;
                for (int x = indexStart1; x < indexEnd1; ++x) {
                    int i1 = 0;
                    for (int y = indexStart2; y < indexEnd2; ++y) {
                        ret[i1 * size + i2] = in[x][y];
                        ++i1;
                    }
                    ++i2;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return ret;
        }

        private void monitorPos(MonitorBlockEntity pos, int x, int y, Consumer<Vec2i> v) {
            int index1 = 0;
            for (List<MonitorBlockEntity> cMonList : this.getMonitors(false)) {
                int index2 = cMonList.size() - 1;
                for (MonitorBlockEntity mon : cMonList) {
                    if (mon != null && mon == pos) {
                        int xP = x + this.size * index1;
                        int yP = y + this.size * index2;
                        v.accept(new Vec2i(xP + 1, yP + 1));
                        return;
                    }
                    --index2;
                }
                ++index1;
            }
        }

        public void monitorClick(MonitorBlockEntity pos, int x, int y, boolean soft) {
            this.monitorPos(pos, x, y, p -> this.queueEvent("tm_monitor_touch", new Object[]{p.x, p.y, soft}));
        }

        public void monitorEvent(MonitorBlockEntity pos, String ev, int x, int y, Integer param) {
            this.monitorPos(pos, x, y, p -> this.queueEvent("tm_monitor_" + ev, new Object[]{p.x, p.y, param}));
        }

        public void queueEvent(String event, Object[] args) {
            Object[] a = new Object[args.length + 1];
            for (int i = 0; i < args.length; ++i) {
                a[i + 1] = args[i];
            }
            for (IComputer c : this.computers) {
                a[0] = c.getAttachmentName();
                c.queueEvent(event, a);
            }
        }

        private List<List<MonitorBlockEntity>> getMonitors(boolean forceRefresh) {
            if (this.monitors == null || forceRefresh) {
                this.monitors = this.connectMonitors(this.findMonitor());
            }
            return this.monitors;
        }

        @Override
        public int getWidth() {
            return this.maxX * this.size;
        }

        @Override
        public int getHeight() {
            return this.maxY * this.size;
        }

        @Override
        public VRAM getVRam() {
            return this.vram;
        }

        @Override
        public long getSize() {
            return this.maxX * this.size * this.maxY * this.size * 4;
        }
    }

    public static class GPUExt
    extends GPUImpl {
        private GPUPeripheral gpu;
        private AtomicBoolean refreshSizeRunning = new AtomicBoolean(false);

        public GPUExt(GPUPeripheral ctx) {
            super(ctx);
            this.gpu = ctx;
        }

        @LuaMethod
        public void setSize(Object[] a) throws LuaException {
            int s = ParamCheck.getInt(a, 0);
            if (s < 16) {
                throw new LuaException("Bad Argument #1, (too small number (" + s + ") minimum value is 16 )");
            }
            if (s > 64) {
                throw new LuaException("Bad Argument #1, (too big number (" + s + ") maximum value is 64 )");
            }
            int size = s * this.gpu.maxX * s * this.gpu.maxY * 4;
            this.gpu.vram.reallocEx(this.gpu, size);
            this.gpu.screen = new int[s * this.gpu.maxX][s * this.gpu.maxY];
            this.gpu.size = s;
        }

        @LuaMethod
        public void refreshSize() {
            if (this.refreshSizeRunning.compareAndSet(false, true)) {
                Platform.getServer().execute(() -> {
                    try {
                        this.gpu.getMonitors(true);
                    }
                    finally {
                        this.refreshSizeRunning.set(false);
                    }
                });
            }
        }

        @Override
        @LuaMethod
        public Object[] getSize() {
            return new Object[]{this.ctx.getWidth(), this.ctx.getHeight(), this.gpu.maxX, this.gpu.maxY, this.gpu.size};
        }
    }
}

