/*
 * Decompiled with CFR 0.152.
 */
package fuzs.metalbundles.world.item;

import fuzs.puzzlesapi.api.iteminteractions.v1.ContainerItemHelper;
import fuzs.puzzlesapi.api.iteminteractions.v1.provider.ItemContainerProvider;
import fuzs.puzzleslib.api.core.v1.Proxy;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.stream.Stream;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1277;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2561;
import net.minecraft.class_3417;
import net.minecraft.class_3468;
import net.minecraft.class_3532;
import net.minecraft.class_5328;
import org.jetbrains.annotations.Nullable;

public class MetalBundleItem
extends class_1792 {
    public static final int LEATHER_BUNDLE_CAPACITY = 64;
    public static final int COPPER_BUNDLE_CAPACITY = 128;
    public static final int IRON_BUNDLE_CAPACITY = 512;
    public static final int GOLDEN_BUNDLE_CAPACITY = 1024;
    public static final int DIAMOND_BUNDLE_CAPACITY = 2048;
    public static final int NETHERITE_BUNDLE_CAPACITY = 4096;
    private static final int BAR_COLOR = class_3532.method_15353((float)0.4f, (float)0.4f, (float)1.0f);
    public final int capacity;

    public MetalBundleItem(int capacity, class_1792.class_1793 properties) {
        super(properties);
        this.capacity = capacity;
    }

    public class_1271<class_1799> method_7836(class_1937 level, class_1657 player, class_1268 usedHand) {
        class_1799 stackInHand = player.method_5998(usedHand);
        ItemContainerProvider provider = ContainerItemHelper.INSTANCE.getItemContainerProvider(stackInHand);
        Objects.requireNonNull(provider, "provider is null");
        class_1277 container = provider.getItemContainer(stackInHand, player, true);
        List items = container.method_24514();
        items.forEach(item -> player.method_7328(item, true));
        if (!items.isEmpty()) {
            player.method_5783(class_3417.field_34375, 0.8f, 0.8f + level.method_8409().method_43057() * 0.4f);
            player.method_7259(class_3468.field_15372.method_14956((Object)this));
            return class_1271.method_29237((Object)stackInHand, (boolean)level.method_8608());
        }
        return class_1271.method_22431((Object)stackInHand);
    }

    public boolean method_31567(class_1799 stack) {
        return MetalBundleItem.getContentWeight(stack) > 0;
    }

    public int method_31569(class_1799 stack) {
        return Math.min(1 + 12 * MetalBundleItem.getContentWeight(stack) / this.capacity, 13);
    }

    public int method_31571(class_1799 stack) {
        return BAR_COLOR;
    }

    public void method_7851(class_1799 stack, class_1937 level, List<class_2561> tooltipComponents, class_1836 isAdvanced) {
        tooltipComponents.add((class_2561)class_2561.method_43469((String)"item.minecraft.bundle.fullness", (Object[])new Object[]{MetalBundleItem.getContentWeight(stack), this.capacity}).method_27692(class_124.field_1080));
    }

    public void method_33261(class_1542 itemEntity) {
        ItemContainerProvider provider = ContainerItemHelper.INSTANCE.getItemContainerProvider(itemEntity.method_6983());
        Objects.requireNonNull(provider, "provider is null");
        class_1277 container = provider.getItemContainer(itemEntity.method_6983(), null, true);
        Stream<class_1799> stream = ContainerItemHelper.INSTANCE.getListFromContainer(container).stream().filter(Predicate.not(class_1799::method_7960));
        class_5328.method_33263((class_1542)itemEntity, stream);
    }

    public static int getContentWeight(class_1799 containerStack) {
        return MetalBundleItem.getContentWeight(containerStack, Proxy.INSTANCE.getClientPlayer());
    }

    public static int getContentWeight(class_1799 containerStack, @Nullable class_1657 player) {
        ItemContainerProvider provider = ContainerItemHelper.INSTANCE.getItemContainerProvider(containerStack);
        Objects.requireNonNull(provider, "provider is null");
        return MetalBundleItem.getContentWeight(provider, containerStack, player);
    }

    public static int getContentWeight(ItemContainerProvider provider, class_1799 containerStack, class_1657 player) {
        class_1277 container = provider.getItemContainer(containerStack, player, false);
        return ContainerItemHelper.INSTANCE.getListFromContainer(container).stream().mapToInt(stack -> MetalBundleItem.getItemWeight(stack) * stack.method_7947()).sum();
    }

    public static int getItemWeight(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof MetalBundleItem) {
            MetalBundleItem item = (MetalBundleItem)class_17922;
            return item.capacity / 16 + MetalBundleItem.getContentWeight(stack, null);
        }
        return ContainerItemHelper.INSTANCE.getItemWeight(stack);
    }
}

