/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.portal;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.AetherBlocks;
import com.aetherteam.aether.block.portal.AetherPortalBlock;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2423;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4970;
import org.jetbrains.annotations.Nullable;

public class AetherPortalShape {
    private static final class_4970.class_4973 FRAME = (state, level, pos) -> state.method_26164(AetherTags.Blocks.AETHER_PORTAL_BLOCKS);
    private final class_1936 level;
    private final class_2350.class_2351 axis;
    private final class_2350 rightDir;
    private int numPortalBlocks;
    @Nullable
    private class_2338 bottomLeft;
    private int height;
    private final int width;

    public static Optional<AetherPortalShape> findEmptyAetherPortalShape(class_1936 level, class_2338 bottomLeft, class_2350.class_2351 axis) {
        return AetherPortalShape.findPortalShape(level, bottomLeft, shape -> shape.isValid() && shape.numPortalBlocks == 0, axis);
    }

    public static Optional<AetherPortalShape> findPortalShape(class_1936 level, class_2338 bottomLeft, Predicate<AetherPortalShape> predicate, class_2350.class_2351 axis) {
        Optional<AetherPortalShape> optional = Optional.of(new AetherPortalShape(level, bottomLeft, axis)).filter(predicate);
        if (optional.isPresent()) {
            return optional;
        }
        class_2350.class_2351 directionAxis = axis == class_2350.class_2351.field_11048 ? class_2350.class_2351.field_11051 : class_2350.class_2351.field_11048;
        return Optional.of(new AetherPortalShape(level, bottomLeft, directionAxis)).filter(predicate);
    }

    public AetherPortalShape(class_1936 level, class_2338 bottomLeft, class_2350.class_2351 axis) {
        this.level = level;
        this.axis = axis;
        this.rightDir = axis == class_2350.class_2351.field_11048 ? class_2350.field_11039 : class_2350.field_11035;
        this.bottomLeft = this.calculateBottomLeft(bottomLeft);
        if (this.bottomLeft == null) {
            this.bottomLeft = bottomLeft;
            this.width = 1;
            this.height = 1;
        } else {
            this.width = this.calculateWidth();
            if (this.width > 0) {
                this.height = this.calculateHeight();
            }
        }
    }

    @Nullable
    private class_2338 calculateBottomLeft(class_2338 pos) {
        int i = Math.max(this.level.method_31607(), pos.method_10264() - 21);
        while (pos.method_10264() > i && AetherPortalShape.isEmpty(this.level.method_8320(pos.method_10074()))) {
            pos = pos.method_10074();
        }
        class_2350 direction = this.rightDir.method_10153();
        int j = this.getDistanceUntilEdgeAboveFrame(pos, direction) - 1;
        return j < 0 ? null : pos.method_10079(direction, j);
    }

    private int calculateWidth() {
        int i = this.getDistanceUntilEdgeAboveFrame(this.bottomLeft, this.rightDir);
        return i >= 2 && i <= 21 ? i : 0;
    }

    private int getDistanceUntilEdgeAboveFrame(class_2338 pos, class_2350 direction) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (int i = 0; i <= 21; ++i) {
            mutablePos.method_10101((class_2382)pos).method_10104(direction, i);
            class_2680 blockState = this.level.method_8320((class_2338)mutablePos);
            if (!AetherPortalShape.isEmpty(blockState)) {
                if (!FRAME.test(blockState, (class_1922)this.level, (class_2338)mutablePos)) break;
                return i;
            }
            class_2680 belowState = this.level.method_8320((class_2338)mutablePos.method_10098(class_2350.field_11033));
            if (!FRAME.test(belowState, (class_1922)this.level, (class_2338)mutablePos)) break;
        }
        return 0;
    }

    private int calculateHeight() {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        int i = this.getDistanceUntilTop(mutablePos);
        return i >= 3 && i <= 21 && this.hasTopFrame(mutablePos, i) ? i : 0;
    }

    private boolean hasTopFrame(class_2338.class_2339 mutablePos, int amount) {
        for (int i = 0; i < this.width; ++i) {
            class_2338.class_2339 movedPos = mutablePos.method_10101((class_2382)this.bottomLeft).method_10104(class_2350.field_11036, amount).method_10104(this.rightDir, i);
            if (FRAME.test(this.level.method_8320((class_2338)movedPos), (class_1922)this.level, (class_2338)movedPos)) continue;
            return false;
        }
        return true;
    }

    private int getDistanceUntilTop(class_2338.class_2339 mutablePos) {
        for (int i = 0; i < 21; ++i) {
            mutablePos.method_10101((class_2382)this.bottomLeft).method_10104(class_2350.field_11036, i).method_10104(this.rightDir, -1);
            if (!FRAME.test(this.level.method_8320((class_2338)mutablePos), (class_1922)this.level, (class_2338)mutablePos)) {
                return i;
            }
            mutablePos.method_10101((class_2382)this.bottomLeft).method_10104(class_2350.field_11036, i).method_10104(this.rightDir, this.width);
            if (!FRAME.test(this.level.method_8320((class_2338)mutablePos), (class_1922)this.level, (class_2338)mutablePos)) {
                return i;
            }
            for (int j = 0; j < this.width; ++j) {
                mutablePos.method_10101((class_2382)this.bottomLeft).method_10104(class_2350.field_11036, i).method_10104(this.rightDir, j);
                class_2680 blockState = this.level.method_8320((class_2338)mutablePos);
                if (!AetherPortalShape.isEmpty(blockState)) {
                    return i;
                }
                if (!blockState.method_27852((class_2248)AetherBlocks.AETHER_PORTAL.get())) continue;
                ++this.numPortalBlocks;
            }
        }
        return 21;
    }

    private static boolean isEmpty(class_2680 state) {
        return state.method_26215() || state.method_27852(class_2246.field_10382) || state.method_27852((class_2248)AetherBlocks.AETHER_PORTAL.get());
    }

    public boolean isValid() {
        return this.bottomLeft != null && this.width >= 2 && this.width <= 21 && this.height >= 3 && this.height <= 21;
    }

    public void createPortalBlocks() {
        class_2680 blockState = (class_2680)((AetherPortalBlock)((Object)AetherBlocks.AETHER_PORTAL.get())).method_9564().method_11657((class_2769)class_2423.field_11310, (Comparable)this.axis);
        class_2338.method_10097((class_2338)this.bottomLeft, (class_2338)this.bottomLeft.method_10079(class_2350.field_11036, this.height - 1).method_10079(this.rightDir, this.width - 1)).forEach(pos -> this.level.method_8652(pos, blockState, 18));
    }

    public boolean isComplete() {
        return this.isValid() && this.numPortalBlocks == this.width * this.height;
    }
}

