/*
 * Decompiled with CFR 0.152.
 */
package com.aetherteam.aether.block.portal;

import com.aetherteam.aether.AetherTags;
import com.aetherteam.aether.block.portal.AetherPortalForcer;
import com.aetherteam.aether.block.portal.AetherPortalShape;
import com.aetherteam.aether.capability.AetherCapabilities;
import com.aetherteam.aether.client.AetherSoundEvents;
import com.aetherteam.aether.client.particle.AetherParticleTypes;
import com.aetherteam.aether.client.sound.FadeOutSoundInstance;
import com.aetherteam.aether.mixin.mixins.common.accessor.EntityAccessor;
import com.aetherteam.aether.world.LevelUtil;
import io.github.fabricators_of_create.porting_lib.entity.ITeleporter;
import java.util.Optional;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1113;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2394;
import net.minecraft.class_2470;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2741;
import net.minecraft.class_2754;
import net.minecraft.class_2769;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_3726;
import net.minecraft.class_4970;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.server.MinecraftServer;

public class AetherPortalBlock
extends class_2248 {
    public static final class_2754<class_2350.class_2351> AXIS = class_2741.field_12529;
    protected static final class_265 X_AXIS_AABB = class_2248.method_9541((double)0.0, (double)0.0, (double)6.0, (double)16.0, (double)16.0, (double)10.0);
    protected static final class_265 Z_AXIS_AABB = class_2248.method_9541((double)6.0, (double)0.0, (double)0.0, (double)10.0, (double)16.0, (double)16.0);

    public AetherPortalBlock(class_4970.class_2251 properties) {
        super(properties);
        this.method_9590((class_2680)((class_2680)this.method_9595().method_11664()).method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048));
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{AXIS});
    }

    public void method_9548(class_2680 state, class_1937 level, class_2338 pos, class_1297 entity) {
        EntityAccessor entityAccessor = (EntityAccessor)entity;
        if (!entity.method_5765() && !entity.method_5782() && entity.method_5822() && !entity.method_5864().method_20210(AetherTags.Entities.DUNGEON_ENTITIES)) {
            if (entity.method_30230()) {
                entity.method_30229();
            } else {
                Optional aetherPlayer;
                if (!entity.method_37908().method_8608() && !pos.equals((Object)entityAccessor.aether$getPortalEntrancePos())) {
                    entityAccessor.aether$setPortalEntrancePos(pos.method_10062());
                }
                if (!(aetherPlayer = AetherCapabilities.AETHER_PLAYER_CAPABILITY.maybeGet((Object)entity)).isPresent()) {
                    this.handleTeleportation(entity);
                } else {
                    aetherPlayer.ifPresent(handler -> {
                        handler.setInPortal(true);
                        int waitTime = handler.getPortalTimer();
                        if (waitTime >= entity.method_5741()) {
                            this.handleTeleportation(entity);
                            handler.setPortalTimer(0);
                        }
                    });
                }
            }
        }
    }

    private void handleTeleportation(class_1297 entity) {
        class_3218 destinationLevel;
        class_5321<class_1937> destinationKey;
        MinecraftServer server = entity.method_37908().method_8503();
        class_5321<class_1937> class_53212 = destinationKey = entity.method_37908().method_27983() == LevelUtil.destinationDimension() ? LevelUtil.returnDimension() : LevelUtil.destinationDimension();
        if (server != null && (destinationLevel = server.method_3847(destinationKey)) != null && !entity.method_5765()) {
            entity.method_37908().method_16107().method_15396("aether_portal");
            entity.method_30229();
            entity.changeDimension(destinationLevel, (ITeleporter)new AetherPortalForcer(destinationLevel, true));
            entity.method_37908().method_16107().method_15407();
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void method_9496(class_2680 state, class_1937 level, class_2338 pos, class_5819 random) {
        if (random.method_43048(100) == 0) {
            class_310.method_1551().method_1483().method_4873((class_1113)new FadeOutSoundInstance((class_3414)AetherSoundEvents.BLOCK_AETHER_PORTAL_AMBIENT.get(), class_3419.field_15245, 0.5f, random.method_43057() * 0.4f + 0.8f, class_5819.method_43049((long)random.method_43055()), false, 0, class_1113.class_1114.field_5476, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, false));
        }
        for (int i = 0; i < 4; ++i) {
            double x = (double)pos.method_10263() + random.method_43058();
            double y = (double)pos.method_10264() + random.method_43058();
            double z = (double)pos.method_10260() + random.method_43058();
            double xSpeed = ((double)random.method_43057() - 0.5) * 0.5;
            double ySpeed = ((double)random.method_43057() - 0.5) * 0.5;
            double zSpeed = ((double)random.method_43057() - 0.5) * 0.5;
            int j = random.method_43048(2) * 2 - 1;
            if (!level.method_8320(pos.method_10067()).method_27852((class_2248)this) && !level.method_8320(pos.method_10078()).method_27852((class_2248)this)) {
                x = (double)pos.method_10263() + 0.5 + 0.25 * (double)j;
                xSpeed = random.method_43057() * 2.0f * (float)j;
            } else {
                z = (double)pos.method_10260() + 0.5 + 0.25 * (double)j;
                zSpeed = random.method_43057() * 2.0f * (float)j;
            }
            level.method_8406((class_2394)AetherParticleTypes.AETHER_PORTAL.get(), x, y, z, xSpeed, ySpeed, zSpeed);
        }
    }

    public class_2680 method_9598(class_2680 state, class_2470 rotation) {
        return switch (rotation) {
            case class_2470.field_11465, class_2470.field_11463 -> {
                switch ((class_2350.class_2351)state.method_11654(AXIS)) {
                    case field_11051: {
                        yield (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11048);
                    }
                    case field_11048: {
                        yield (class_2680)state.method_11657(AXIS, (Comparable)class_2350.class_2351.field_11051);
                    }
                }
                yield state;
            }
            default -> state;
        };
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        if (state.method_11654(AXIS) == class_2350.class_2351.field_11051) {
            return Z_AXIS_AABB;
        }
        return X_AXIS_AABB;
    }

    public class_2680 method_9559(class_2680 state, class_2350 direction, class_2680 facingState, class_1936 level, class_2338 currentPos, class_2338 facingPos) {
        class_2350.class_2351 directionAxis = direction.method_10166();
        class_2350.class_2351 blockAxis = (class_2350.class_2351)state.method_11654(AXIS);
        boolean flag = blockAxis != directionAxis && directionAxis.method_10179();
        return !flag && !facingState.method_27852((class_2248)this) && !new AetherPortalShape(level, currentPos, blockAxis).isComplete() ? class_2246.field_10124.method_9564() : super.method_9559(state, direction, facingState, level, currentPos, facingPos);
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        return class_1799.field_8037;
    }
}

