/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.registry;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import dev.emi.emi.EmiPort;
import dev.emi.emi.EmiUtil;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiRegistryAdapter;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.stack.ListEmiIngredient;
import dev.emi.emi.api.stack.TagEmiIngredient;
import dev.emi.emi.config.EmiConfig;
import dev.emi.emi.data.TagExclusions;
import dev.emi.emi.platform.EmiAgnos;
import dev.emi.emi.runtime.EmiHidden;
import dev.emi.emi.runtime.EmiReloadLog;
import dev.emi.emi.util.InheritanceMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_1074;
import net.minecraft.class_1091;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2378;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3300;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class EmiTags {
    public static final InheritanceMap<EmiRegistryAdapter<?>> ADAPTERS_BY_CLASS = new InheritanceMap(Maps.newHashMap());
    public static final Map<class_2378<?>, EmiRegistryAdapter<?>> ADAPTERS_BY_REGISTRY = Maps.newHashMap();
    public static final class_2960 HIDDEN_FROM_RECIPE_VIEWERS = EmiPort.id("c", "hidden_from_recipe_viewers");
    private static final Map<class_6862<?>, class_2960> MODELED_TAGS = Maps.newHashMap();
    private static final Map<Set<?>, List<class_6862<?>>> CACHED_TAGS = Maps.newHashMap();
    private static final Map<class_6862<?>, List<?>> TAG_CONTENTS = Maps.newHashMap();
    private static final Map<class_6862<?>, List<?>> TAG_VALUES = Maps.newHashMap();
    private static final Map<class_2960, List<class_6862<?>>> SORTED_TAGS = Maps.newHashMap();
    public static final List<class_6862<?>> TAGS = Lists.newArrayList();
    public static TagExclusions exclusions = new TagExclusions();

    public static <T> class_2378<T> getRegistry(class_6862<T> key) {
        class_310 client = class_310.method_1551();
        return client.field_1687.method_30349().method_33310(key.comp_326()).orElse(null);
    }

    public static <T> List<EmiStack> getValues(class_6862<T> key) {
        EmiRegistryAdapter<?> adapter;
        if (TAG_VALUES.containsKey(key) && (adapter = ADAPTERS_BY_REGISTRY.get(EmiTags.getRegistry(key))) != null) {
            List values = TAG_VALUES.getOrDefault(key, List.of());
            return values.stream().map(t -> adapter.of(t, EmiPort.emptyExtraData(), 1L)).toList();
        }
        return List.of();
    }

    public static <T> List<EmiStack> getRawValues(class_6862<T> key) {
        if (key.comp_326().equals(EmiPort.getBlockRegistry().method_30517())) {
            return EmiUtil.values(key).map(e -> EmiStack.of((class_1935)((class_2248)e.comp_349()))).toList();
        }
        EmiRegistryAdapter<?> adapter = ADAPTERS_BY_REGISTRY.get(EmiTags.getRegistry(key));
        if (adapter != null) {
            List<Object> values = EmiUtil.values(key).map(class_6880::comp_349).toList();
            return values.stream().map(t -> adapter.of(t, EmiPort.emptyExtraData(), 1L)).toList();
        }
        return List.of();
    }

    public static <T> EmiIngredient getIngredient(Class<T> clazz, List<EmiStack> stacks, long amount) {
        HashMap map = Maps.newHashMap();
        for (EmiStack stack : stacks) {
            if (stack.isEmpty()) continue;
            EmiStack existing = map.getOrDefault(stack.getKey(), null);
            if (existing != null && !stack.equals(existing)) {
                return new ListEmiIngredient(stacks, amount);
            }
            map.put(stack.getKey(), stack);
        }
        if (map.size() == 0) {
            return EmiStack.EMPTY;
        }
        if (map.size() == 1) {
            return ((EmiStack)map.values().stream().toList().get(0)).copy().setAmount(amount);
        }
        EmiRegistryAdapter<?> adapter = ADAPTERS_BY_CLASS.get(clazz);
        if (adapter == null) {
            return new ListEmiIngredient(stacks, amount);
        }
        class_2378<?> registry = adapter.getRegistry();
        ArrayList keys = CACHED_TAGS.get(map.keySet());
        if (keys != null) {
            for (class_6862<?> key : keys) {
                List<?> values = TAG_CONTENTS.get(key);
                values.forEach(map::remove);
            }
        } else {
            keys = Lists.newArrayList();
            HashSet original = new HashSet(map.keySet());
            for (class_6862<?> key : EmiTags.getTags(registry)) {
                List<?> values = TAG_CONTENTS.get(key);
                if (values.size() < 2) continue;
                if (map.keySet().containsAll(values)) {
                    values.forEach(map::remove);
                    keys.add(key);
                }
                if (!map.isEmpty()) continue;
                break;
            }
            CACHED_TAGS.put(original, keys);
        }
        if (keys == null || keys.isEmpty()) {
            return new ListEmiIngredient(stacks.stream().toList(), amount);
        }
        if (map.isEmpty()) {
            if (keys.size() == 1) {
                return EmiTags.tagIngredient((class_6862)keys.get(0), amount);
            }
            return new ListEmiIngredient(keys.stream().map(k -> EmiTags.tagIngredient(k, 1L)).toList(), amount);
        }
        return new ListEmiIngredient(List.of(map.values().stream().map(i -> i.copy().setAmount(1L)).toList(), keys.stream().map(k -> EmiTags.tagIngredient(k, 1L)).toList()).stream().flatMap(a -> a.stream()).toList(), amount);
    }

    private static EmiIngredient tagIngredient(class_6862<?> key, long amount) {
        List<?> list = TAG_VALUES.get(key);
        if (list == null || list.isEmpty()) {
            return EmiStack.EMPTY;
        }
        if (list.size() == 1) {
            return new TagEmiIngredient(key, amount).getEmiStacks().get(0).copy().setAmount(amount);
        }
        return new TagEmiIngredient(key, amount);
    }

    public static <T> List<class_6862<T>> getTags(class_2378<T> registry) {
        return SORTED_TAGS.getOrDefault(registry.method_30517().method_29177(), List.of());
    }

    public static class_2561 getTagName(class_6862<?> key) {
        String s = EmiTags.getTagTranslationKey(key);
        if (s == null) {
            return EmiPort.literal("#" + String.valueOf(key.comp_327()));
        }
        return EmiPort.translatable(s);
    }

    public static boolean hasTranslation(class_6862<?> key) {
        return EmiTags.getTagTranslationKey(key) != null;
    }

    @Nullable
    private static String getTagTranslationKey(class_6862<?> key) {
        class_2960 registry = key.comp_326().method_29177();
        if (registry.method_12836().equals("minecraft")) {
            String s = EmiTags.translatePrefix("tag." + registry.method_12832().replace("/", ".") + ".", key.comp_327());
            if (s != null) {
                return s;
            }
        } else {
            String s = EmiTags.translatePrefix("tag." + registry.method_12836() + "." + registry.method_12832().replace("/", ".") + ".", key.comp_327());
            if (s != null) {
                return s;
            }
        }
        return EmiTags.translatePrefix("tag.", key.comp_327());
    }

    @Nullable
    private static String translatePrefix(String prefix, class_2960 id) {
        String s = EmiUtil.translateId(prefix, id);
        if (class_1074.method_4663((String)s)) {
            return s;
        }
        if (id.method_12836().equals("forge") && class_1074.method_4663((String)(s = EmiUtil.translateId(prefix, EmiPort.id("c", id.method_12832()))))) {
            return s;
        }
        return null;
    }

    @Nullable
    public static class_2960 getCustomModel(class_6862<?> key) {
        class_2960 rid = key.comp_327();
        if (rid.method_12836().equals("forge") && !MODELED_TAGS.containsKey(key)) {
            key = class_6862.method_40092((class_5321)key.comp_326(), (class_2960)EmiPort.id("c", rid.method_12832()));
        }
        return MODELED_TAGS.get(key);
    }

    public static boolean hasCustomModel(class_6862<?> key) {
        return EmiTags.getCustomModel(key) != null;
    }

    public static void registerTagModels(class_3300 manager, Consumer<class_2960> consumer) {
        String[] parts;
        String path;
        MODELED_TAGS.clear();
        for (class_2960 id : EmiPort.findResources(manager, "models/tag", s -> s.endsWith(".json"))) {
            path = id.method_12832();
            parts = (path = path.substring(11, path.length() - 5)).split("/");
            if (parts.length <= 1) continue;
            class_6862 key = class_6862.method_40092((class_5321)class_5321.method_29180((class_2960)EmiPort.id("minecraft", parts[0])), (class_2960)EmiPort.id(id.method_12836(), path.substring(1 + parts[0].length())));
            class_2960 mid = EmiPort.id(id.method_12836(), "tag/" + path);
            MODELED_TAGS.put(key, mid);
            consumer.accept(mid);
        }
        for (class_2960 id : EmiPort.findResources(manager, "models/item/tags", s -> s.endsWith(".json"))) {
            path = id.method_12832();
            path = path.substring(0, path.length() - 5);
            parts = path.substring(17).split("/");
            if (!id.method_12836().equals("emi") || parts.length <= 1) continue;
            class_1091 mid = new class_1091(id.method_12836(), path.substring(12), "inventory");
            MODELED_TAGS.put(class_6862.method_40092((class_5321)EmiPort.getItemRegistry().method_30517(), (class_2960)EmiPort.id(parts[0], path.substring(18 + parts[0].length()))), (class_2960)mid);
            consumer.accept((class_2960)mid);
        }
    }

    public static void reload() {
        TAGS.clear();
        SORTED_TAGS.clear();
        TAG_CONTENTS.clear();
        TAG_VALUES.clear();
        CACHED_TAGS.clear();
        for (class_2378<?> registry : ADAPTERS_BY_REGISTRY.keySet()) {
            EmiTags.reloadTags(registry);
        }
    }

    private static <T> void reloadTags(class_2378<T> registry) {
        Set hidden = EmiUtil.values(class_6862.method_40092((class_5321)registry.method_30517(), (class_2960)HIDDEN_FROM_RECIPE_VIEWERS)).map(class_6880::comp_349).collect(Collectors.toSet());
        class_2960 rid = registry.method_30517().method_29177();
        List<Object> tags = registry.method_40273().filter(key -> !exclusions.contains(rid, key.comp_327()) && !hidden.containsAll(EmiUtil.values(key).map(class_6880::comp_349).toList())).toList();
        EmiTags.logUntranslatedTags(tags);
        tags = EmiTags.consolodateTags(tags);
        for (class_6862 key2 : tags) {
            List<Object> contents = EmiUtil.values(key2).map(i -> i.comp_349()).toList();
            TAG_CONTENTS.put(key2, contents);
            List<Object> values = contents.stream().filter(s -> !EmiHidden.isDisabled(EmiTags.stackFromKey(key2, s))).toList();
            if (values.isEmpty()) {
                TAG_VALUES.put(key2, contents);
                continue;
            }
            TAG_VALUES.put(key2, values);
        }
        TAGS.addAll(tags.stream().sorted((a, b) -> a.toString().compareTo(b.toString())).toList());
        tags = tags.stream().sorted((a, b) -> Long.compare(EmiUtil.values(b).count(), EmiUtil.values(a).count())).toList();
        SORTED_TAGS.put(registry.method_30517().method_29177(), tags);
    }

    private static <T> EmiStack stackFromKey(class_6862<T> key, T t) {
        EmiRegistryAdapter<?> adapter = ADAPTERS_BY_REGISTRY.get(EmiTags.getRegistry(key));
        if (adapter != null) {
            return adapter.of(t, EmiPort.emptyExtraData(), 1L);
        }
        throw new UnsupportedOperationException("Unsupported tag registry " + String.valueOf(key));
    }

    private static <T> void logUntranslatedTags(List<class_6862<T>> tags) {
        if (EmiConfig.logUntranslatedTags) {
            ArrayList untranslated = Lists.newArrayList();
            for (Object tag : tags) {
                if (EmiTags.hasTranslation(tag)) continue;
                untranslated.add(tag.comp_327().toString());
            }
            if (!untranslated.isEmpty()) {
                for (Object tag : untranslated.stream().sorted().toList()) {
                    EmiReloadLog.warn("Untranslated tag #" + tag);
                }
                EmiReloadLog.info(" Tag warning can be disabled in the config, EMI docs describe how to add a translation or exclude tags.");
            }
        }
    }

    private static <T> List<class_6862<T>> consolodateTags(List<class_6862<T>> tags) {
        HashMap map = Maps.newHashMap();
        for (int i = 0; i < tags.size(); ++i) {
            class_6862<T> key = tags.get(i);
            Set values = EmiUtil.values(key).map(class_6880::comp_349).collect(Collectors.toSet());
            class_6862 original = (class_6862)map.get(values);
            if (original != null) {
                map.put(values, EmiTags.betterTag(key, original));
                continue;
            }
            map.put(values, key);
        }
        return map.values().stream().toList();
    }

    private static <T> class_6862<T> betterTag(class_6862<T> a, class_6862<T> b) {
        String bn;
        if (EmiTags.hasTranslation(a) != EmiTags.hasTranslation(b)) {
            return EmiTags.hasTranslation(a) ? a : b;
        }
        if (EmiTags.hasCustomModel(a) != EmiTags.hasCustomModel(b)) {
            return EmiTags.hasCustomModel(a) ? a : b;
        }
        String an = a.comp_327().method_12836();
        if (!an.equals(bn = b.comp_327().method_12836())) {
            if (an.equals("minecraft")) {
                return a;
            }
            if (bn.equals("minecraft")) {
                return b;
            }
            if (an.equals("c")) {
                return a;
            }
            if (bn.equals("c")) {
                return b;
            }
            if (an.equals("fabric")) {
                return EmiAgnos.isModLoaded("forge") ? b : a;
            }
            if (bn.equals("fabric")) {
                return EmiAgnos.isModLoaded("forge") ? a : b;
            }
            if (an.equals("forge")) {
                return EmiAgnos.isModLoaded("forge") ? a : b;
            }
            if (bn.equals("forge")) {
                return EmiAgnos.isModLoaded("forge") ? b : a;
            }
        }
        return a.comp_327().toString().length() <= b.comp_327().toString().length() ? a : b;
    }
}

