/*
 * Decompiled with CFR 0.152.
 */
package dev.emi.emi.recipe.special;

import com.google.common.collect.Lists;
import dev.emi.emi.api.recipe.EmiPatternCraftingRecipe;
import dev.emi.emi.api.stack.EmiIngredient;
import dev.emi.emi.api.stack.EmiStack;
import dev.emi.emi.api.widget.GeneratedSlotWidget;
import dev.emi.emi.api.widget.SlotWidget;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.minecraft.class_1767;
import net.minecraft.class_1769;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;

public class EmiFireworkStarFadeRecipe
extends EmiPatternCraftingRecipe {
    private static final List<class_1769> DYES = Stream.of(class_1767.values()).map(class_1769::method_7803).toList();

    public EmiFireworkStarFadeRecipe(class_2960 id) {
        super(List.of(EmiIngredient.of(DYES.stream().map(i -> EmiStack.of((class_1935)i)).collect(Collectors.toList())), EmiStack.of((class_1935)class_1802.field_8450)), EmiStack.of((class_1935)class_1802.field_8450), id);
    }

    @Override
    public SlotWidget getInputWidget(int slot, int x, int y) {
        return new GeneratedSlotWidget(r -> {
            EmiStack fireworkStar = this.getFireworkStar((Random)r, false);
            List<class_1769> dyeItems = this.getDyes((Random)r, 8);
            int s = slot - 1;
            if (slot == 0) {
                return fireworkStar;
            }
            if (s < dyeItems.size()) {
                return EmiStack.of((class_1935)dyeItems.get(s));
            }
            return EmiStack.EMPTY;
        }, this.unique, x, y);
    }

    @Override
    public SlotWidget getOutputWidget(int x, int y) {
        return new GeneratedSlotWidget(r -> this.getFireworkStar((Random)r, true), this.unique, x, y);
    }

    private List<class_1769> getDyes(Random random, int max) {
        ArrayList dyes = Lists.newArrayList();
        int amount = 1 + random.nextInt(max);
        for (int i = 0; i < amount; ++i) {
            dyes.add(DYES.get(random.nextInt(DYES.size())));
        }
        return dyes;
    }

    private EmiStack getFireworkStar(Random random, Boolean faded) {
        class_1799 stack = new class_1799((class_1935)class_1802.field_8450);
        class_2487 tag = new class_2487();
        class_2487 explosion = new class_2487();
        int items = 0;
        int amount = random.nextInt(5);
        explosion.method_10567("Type", (byte)amount);
        if (amount != 0) {
            ++items;
        }
        if ((amount = random.nextInt(4)) == 0) {
            explosion.method_10567("Flicker", (byte)1);
            ++items;
        } else if (amount == 1) {
            explosion.method_10567("Trail", (byte)1);
            ++items;
        } else if (amount == 2) {
            explosion.method_10567("Trail", (byte)1);
            explosion.method_10567("Flicker", (byte)1);
            items += 2;
        }
        List<class_1769> dyeItems = this.getDyes(random, 8 - items);
        ArrayList colors = Lists.newArrayList();
        for (class_1769 dyeItem : dyeItems) {
            colors.add(dyeItem.method_7802().method_7790());
        }
        explosion.method_10572("Colors", (List)colors);
        if (faded.booleanValue()) {
            List<class_1769> dyeItemsFaded = this.getDyes(random, 8);
            ArrayList fadedColors = Lists.newArrayList();
            for (class_1769 dyeItem : dyeItemsFaded) {
                fadedColors.add(dyeItem.method_7802().method_7790());
            }
            explosion.method_10572("FadeColors", (List)fadedColors);
        }
        tag.method_10566("Explosion", (class_2520)explosion);
        stack.method_7980(tag);
        return EmiStack.of(stack);
    }
}

