/*
 * Decompiled with CFR 0.152.
 */
package team.creative.ambientsounds.block;

import java.util.Optional;
import net.minecraft.class_2248;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import team.creative.ambientsounds.AmbientSounds;
import team.creative.ambientsounds.engine.AmbientEngineLoadException;
import team.creative.creativecore.common.util.type.list.Tuple;
import team.creative.creativecore.common.util.type.list.TupleList;

public abstract class AmbientBlock {
    public static AmbientBlock parse(String data) throws AmbientEngineLoadException {
        if (data.contains("[")) {
            if (!data.endsWith("]")) {
                throw new AmbientEngineLoadException("Cannot parse block entry " + data);
            }
            String[] parts = data.split("\\[");
            if (parts.length > 2) {
                throw new AmbientEngineLoadException("Cannot parse block entry " + data);
            }
            AmbientBlock block = AmbientBlock.parseFirst(parts[0]);
            String[] properties = parts[1].substring(0, parts[1].length() - 1).split(",");
            TupleList found = new TupleList();
            for (int i = 0; i < properties.length; ++i) {
                String[] property = properties[i].split("=");
                if (parts.length != 2) {
                    AmbientSounds.LOGGER.error("Found invalid property condition '{}'. It will be ignored. {}", (Object)properties[i], (Object)data);
                    continue;
                }
                found.add((Object)property[0], (Object)property[1]);
            }
            return new AmbientBlockProperty(block, (TupleList<String, String>)found);
        }
        return AmbientBlock.parseFirst(data);
    }

    private static AmbientBlock parseFirst(String data) {
        if (data.startsWith("#")) {
            return new AmbientBlockTag((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)new class_2960(data.substring(1))));
        }
        return new AmbientBlockBlock(new class_2960(data));
    }

    public abstract boolean is(class_2680 var1);

    public static class AmbientBlockProperty
    extends AmbientBlock {
        public final AmbientBlock block;
        public final TupleList<String, String> properties;

        public AmbientBlockProperty(AmbientBlock block, TupleList<String, String> properties) {
            this.block = block;
            this.properties = properties;
        }

        @Override
        public boolean is(class_2680 state) {
            if (!this.block.is(state)) {
                return false;
            }
            for (int i = 0; i < this.properties.size(); ++i) {
                class_2769 property = state.method_26204().method_9595().method_11663((String)((Tuple)this.properties.get((int)i)).key);
                if (property == null) {
                    return false;
                }
                Optional value = property.method_11900((String)((Tuple)this.properties.get((int)i)).value);
                if (value.isPresent() && state.method_11654(property).equals(value.get())) continue;
                return false;
            }
            return true;
        }
    }

    public static class AmbientBlockTag
    extends AmbientBlock {
        public final class_6862<class_2248> tag;

        public AmbientBlockTag(class_6862<class_2248> tag) {
            this.tag = tag;
        }

        @Override
        public boolean is(class_2680 state) {
            return state.method_26164(this.tag);
        }
    }

    public static class AmbientBlockBlock
    extends AmbientBlock {
        public final class_2960 block;

        public AmbientBlockBlock(class_2960 block) {
            this.block = block;
        }

        @Override
        public boolean is(class_2680 state) {
            return state.method_41520().method_40226(this.block);
        }
    }
}

