/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.gui;

import com.tom.cpl.config.ConfigEntry;
import com.tom.cpl.config.ModConfigFile;
import com.tom.cpl.gui.IGui;
import com.tom.cpl.gui.elements.Button;
import com.tom.cpl.gui.elements.Label;
import com.tom.cpl.gui.elements.PopupPanel;
import com.tom.cpl.math.Box;
import com.tom.cpl.text.IText;
import com.tom.cpl.util.Util;
import com.tom.cpm.shared.config.BuiltInSafetyProfiles;
import com.tom.cpm.shared.config.ConfigChangeRequest;
import com.tom.cpm.shared.config.ConfigKeys;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.config.PlayerSpecificConfigKey;
import com.tom.cpm.shared.config.SocialConfig;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;

public class RecommendSafetySettingsPopup
extends PopupPanel {
    private String server;
    private List<ConfigChangeRequest<?, ?>> changes;

    protected RecommendSafetySettingsPopup(IGui gui, String server, List<ConfigChangeRequest<?, ?>> ch) {
        super(gui);
        this.server = server;
        this.changes = ch;
        ArrayList<String> text = new ArrayList<String>();
        for (ConfigChangeRequest<?, ?> r : ch) {
            if (r.getKey().equals("safetyProfile")) {
                text.addAll(Arrays.asList(gui.i18nFormat("label.cpm.recSettingsChange.title", new Object[0]).split("\\\\")));
                text.add("");
                text.add(gui.i18nFormat("label.cpm.recSettingsChange", gui.i18nFormat("label.cpm.safetyProfileName", new Object[0]), this.translateProfile((String)r.getOldValue()), this.translateProfile((String)r.getNewValue())));
                continue;
            }
            if (!r.getKey().equals("disableNet")) continue;
            text.addAll(Arrays.asList(gui.i18nFormat("label.cpm.recSettingsChange.net", new Object[0]).split("\\\\")));
            text.add("");
            text.add(gui.i18nFormat("label.cpm.recSettingsChange", gui.i18nFormat("label.cpm.safety.blockNetwork", new Object[0]), r.getOldValue(), r.getNewValue()));
        }
        for (ConfigChangeRequest<?, ?> r : ch) {
            if (!(r.getKey() instanceof PlayerSpecificConfigKey)) continue;
            PlayerSpecificConfigKey key = (PlayerSpecificConfigKey)r.getKey();
            String oldV = RecommendSafetySettingsPopup.formatValue(key, r.getOldValue()).toString(gui);
            String newV = RecommendSafetySettingsPopup.formatValue(key, r.getNewValue()).toString(gui);
            text.add(gui.i18nFormat("label.cpm.recSettingsChange", gui.i18nFormat("label.cpm.safety." + key.getName(), new Object[0]), oldV, newV));
        }
        int wm = 310;
        for (String line : text) {
            int w = gui.textWidth(line);
            if (w <= wm) continue;
            wm = w;
        }
        for (int i = 0; i < text.size(); ++i) {
            String line;
            line = (String)text.get(i);
            int w = gui.textWidth(line);
            this.addElement(new Label(gui, line).setBounds(new Box(wm / 2 - w / 2 + 10, 5 + i * 10, 0, 0)));
        }
        int txs = text.size() * 10;
        this.setBounds(new Box(0, 0, wm + 20, 40 + txs));
        Button accept = new Button(gui, gui.i18nFormat("button.cpm.safety.accept", new Object[0]), this::accept);
        accept.setBounds(new Box(5, txs + 15, 80, 20));
        this.addElement(accept);
        Button decline = new Button(gui, gui.i18nFormat("button.cpm.safety.decline", new Object[0]), this::decline);
        decline.setBounds(new Box(90, txs + 15, 80, 20));
        this.addElement(decline);
        Button ignore = new Button(gui, gui.i18nFormat("button.cpm.safety.ignore", new Object[0]), this::ignore);
        ignore.setBounds(new Box(175, txs + 15, 140, 20));
        this.addElement(ignore);
    }

    private void accept() {
        ModConfigFile cc = ModConfig.getCommonConfig();
        ConfigEntry ss = cc.getEntry("serverSettings");
        ConfigEntry se = ss.getEntry(this.server);
        String[] spf = null;
        Enum profile = null;
        for (ConfigChangeRequest<?, ?> r : this.changes) {
            if (r.getKey().equals("safetyProfile")) {
                spf = ((String)r.getNewValue()).split(":");
                profile = SocialConfig.getProfile(spf);
                break;
            }
            if (!r.getKey().equals("disableNet")) continue;
            se.setBoolean("disableNet", false);
            ModConfig.getCommonConfig().save();
            this.changes.clear();
            this.close();
            return;
        }
        if (profile == BuiltInSafetyProfiles.CUSTOM) {
            ConfigEntry ce = cc.getEntry("safetyProfiles").getEntry((String)spf[1]);
            se.setString("safetyProfile", "custom:" + spf[1]);
            ce.setString("name", this.gui.i18nFormat("label.cpm.importedSettings", Util.hideIp(this.server)));
            ce.setBoolean("imported", true);
            for (PlayerSpecificConfigKey k : ConfigKeys.SAFETY_KEYS) {
                boolean setV = false;
                for (ConfigChangeRequest<?, ?> r : this.changes) {
                    if (r.getKey() != k) continue;
                    setV = true;
                    RecommendSafetySettingsPopup.setValue(ce, k, r.getNewValue());
                    break;
                }
                if (setV) continue;
                RecommendSafetySettingsPopup.setValue(ce, k, k.getValueFor(this.server, null, cc));
            }
        } else if (profile != null) {
            se.setString("safetyProfile", profile.name().toLowerCase(Locale.ROOT));
        }
        ModConfig.getCommonConfig().save();
        this.changes.clear();
        this.close();
    }

    private void decline() {
        this.changes.clear();
        this.close();
    }

    private void ignore() {
        this.changes.clear();
        ModConfigFile cc = ModConfig.getCommonConfig();
        ConfigEntry ss = cc.getEntry("serverSettings");
        ss.getEntry(this.server).setBoolean("ignoreSafetyRec", true);
        ModConfig.getCommonConfig().save();
        this.close();
    }

    private static <T> IText formatValue(PlayerSpecificConfigKey<T> key, Object value) {
        return key.formatValue(value);
    }

    private static <T> void setValue(ConfigEntry ce, PlayerSpecificConfigKey<T> key, Object value) {
        key.setValue(ce, value);
    }

    private String translateProfile(String p) {
        String[] spf = p.split(":");
        BuiltInSafetyProfiles profile = SocialConfig.getProfile(spf);
        if (profile == BuiltInSafetyProfiles.CUSTOM) {
            ConfigEntry ce = ModConfig.getCommonConfig().getEntry("safetyProfiles").getEntry(spf[1]);
            String name = ce.getString("name", "???");
            return this.gui.i18nFormat("label.cpm.safetyProfile.custom", name);
        }
        return this.gui.i18nFormat("label.cpm.safetyProfile." + profile.name().toLowerCase(Locale.ROOT), new Object[0]);
    }

    @Override
    public String getTitle() {
        return this.gui.i18nFormat("label.cpm.serverRecommendsSafetySettings", new Object[0]);
    }
}

