/*
 * Decompiled with CFR 0.152.
 */
package com.tom.cpm.shared.editor;

import com.tom.cpl.gui.elements.MessagePopup;
import com.tom.cpm.shared.MinecraftClientAccess;
import com.tom.cpm.shared.config.ModConfig;
import com.tom.cpm.shared.editor.Exporter;
import com.tom.cpm.shared.editor.gui.EditorGui;
import com.tom.cpm.shared.editor.util.GetFreeSkinSlots;

public class TestIngameManager {
    private static final String VANILLA_MODEL = "~~VANILLA~~";
    public static final String TEST_MODEL_NAME = ".temp.cpmmodel";

    public static boolean isTesting() {
        return TEST_MODEL_NAME.equals(ModConfig.getCommonConfig().getString("selectedModel", null));
    }

    public static void checkConfig() {
        String old = ModConfig.getCommonConfig().getString("selectedModelOld", null);
        if (MinecraftClientAccess.get().getServerSideStatus() != MinecraftClientAccess.ServerStatus.INSTALLED) {
            ModConfig.getCommonConfig().clearValue("selectedModelOld");
            String model = ModConfig.getCommonConfig().getString("selectedModel", null);
            if (TEST_MODEL_NAME.equals(model)) {
                if (old == null || VANILLA_MODEL.equals(old)) {
                    ModConfig.getCommonConfig().clearValue("selectedModel");
                } else {
                    ModConfig.getCommonConfig().setString("selectedModel", old);
                }
            }
            ModConfig.getCommonConfig().save();
        }
    }

    public static boolean openTestIngame(EditorGui e, boolean noPopup) {
        if (e.getEditor().dirty || e.getEditor().file == null) {
            e.openPopup(new MessagePopup(e, e.getGui().i18nFormat("label.cpm.error", new Object[0]), e.getGui().i18nFormat("label.cpm.must_save.test", new Object[0])));
            return false;
        }
        try {
            Runnable open;
            if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.INSTALLED) {
                open = () -> {
                    MinecraftClientAccess.get().sendSkinUpdate();
                    if (!noPopup) {
                        e.openPopup(new MessagePopup(e, e.getGui().i18nFormat("label.cpm.info", new Object[0]), e.getGui().i18nFormat("label.cpm.test_model_exported", new Object[0])));
                    }
                };
            } else if (MinecraftClientAccess.get().getServerSideStatus() == MinecraftClientAccess.ServerStatus.OFFLINE) {
                open = MinecraftClientAccess.get().openSingleplayer();
            } else {
                e.openPopup(new MessagePopup(e, e.getGui().i18nFormat("label.cpm.error", new Object[0]), e.getGui().i18nFormat("label.cpm.feature_unavailable", new Object[0])));
                return false;
            }
            if (e.getEditor().animEnc == null) {
                e.getEditor().animEnc = GetFreeSkinSlots.getDefault(e.getEditor());
            }
            if (!Exporter.exportTempModel(e.getEditor(), e.getGui())) {
                return false;
            }
            String model = ModConfig.getCommonConfig().getString("selectedModel", null);
            if (!TEST_MODEL_NAME.equals(model)) {
                if (model != null) {
                    ModConfig.getCommonConfig().setString("selectedModelOld", model);
                } else {
                    ModConfig.getCommonConfig().setString("selectedModelOld", VANILLA_MODEL);
                }
                ModConfig.getCommonConfig().setString("selectedModel", TEST_MODEL_NAME);
            }
            open.run();
            ModConfig.getCommonConfig().setString("reopenProject", e.getEditor().file.getAbsolutePath());
            ModConfig.getCommonConfig().save();
            return true;
        }
        catch (UnsupportedOperationException ex) {
            e.openPopup(new MessagePopup(e, e.getGui().i18nFormat("label.cpm.error", new Object[0]), e.getGui().i18nFormat("label.cpm.test_unsupported", new Object[0])));
            return false;
        }
    }
}

