/*
 * Decompiled with CFR 0.152.
 */
package io.wispforest.accessories.api.attributes;

import com.google.common.collect.Multimap;
import io.wispforest.accessories.api.AccessoriesAPI;
import io.wispforest.accessories.api.attributes.AccessoryAttributeBuilder;
import io.wispforest.accessories.api.slot.SlotType;
import io.wispforest.accessories.utils.AttributeUtils;
import it.unimi.dsi.fastutil.Pair;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1799;
import net.minecraft.class_2960;

public class SlotAttribute
extends class_1320 {
    private static final Map<String, SlotAttribute> CACHED_ATTRIBUTES = new HashMap<String, SlotAttribute>();
    private final String slotName;

    private SlotAttribute(String slotName) {
        super(slotName, 0.0);
        this.slotName = slotName;
    }

    public String slotName() {
        return this.slotName;
    }

    public static SlotAttribute getSlotAttribute(SlotType slotType) {
        return SlotAttribute.getSlotAttribute(slotType.name());
    }

    public static SlotAttribute getSlotAttribute(String slotName) {
        return CACHED_ATTRIBUTES.computeIfAbsent(slotName, SlotAttribute::new);
    }

    public static void addSlotModifier(Multimap<class_1320, class_1322> map, SlotType slotType, class_2960 location, double amount, class_1322.class_1323 operation) {
        Pair<String, UUID> data = AttributeUtils.getModifierData(location);
        SlotAttribute.addSlotModifier(map, slotType.name(), (String)data.first(), (UUID)data.second(), amount, operation);
    }

    public static void addSlotModifier(Multimap<class_1320, class_1322> map, String slot, class_2960 location, double amount, class_1322.class_1323 operation) {
        Pair<String, UUID> data = AttributeUtils.getModifierData(location);
        SlotAttribute.addSlotModifier(map, slot, (String)data.first(), (UUID)data.second(), amount, operation);
    }

    public static void addSlotModifier(Multimap<class_1320, class_1322> map, SlotType slotType, String name, UUID id, double amount, class_1322.class_1323 operation) {
        SlotAttribute.addSlotModifier(map, slotType.name(), name, id, amount, operation);
    }

    public static void addSlotModifier(Multimap<class_1320, class_1322> map, String slot, String name, UUID id, double amount, class_1322.class_1323 operation) {
        map.put((Object)SlotAttribute.getSlotAttribute(slot), (Object)new class_1322(id, name, amount, operation));
    }

    public static void addSlotAttribute(AccessoryAttributeBuilder builder, String targetSlot, class_2960 location, double amount, class_1322.class_1323 operation, boolean isStackable) {
        if (isStackable) {
            builder.addStackable(SlotAttribute.getSlotAttribute(targetSlot), location, amount, operation);
        } else {
            builder.addExclusive(SlotAttribute.getSlotAttribute(targetSlot), location, amount, operation);
        }
    }

    public static void addSlotAttribute(class_1799 stack, String targetSlot, String boundSlot, class_2960 location, double amount, class_1322.class_1323 operation, boolean isStackable) {
        AccessoriesAPI.addAttribute(stack, boundSlot, SlotAttribute.getSlotAttribute(targetSlot), location, amount, operation, isStackable);
    }

    public static void addSlotAttribute(class_1799 stack, String targetSlot, String boundSlot, String name, UUID uuid, double amount, class_1322.class_1323 operation, boolean isStackable) {
        AccessoriesAPI.addAttribute(stack, boundSlot, SlotAttribute.getSlotAttribute(targetSlot), name, uuid, amount, operation, isStackable);
    }
}

