/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.moreiotas.api.casting.iota;

import at.petrak.hexcasting.api.casting.iota.Iota;
import at.petrak.hexcasting.api.casting.iota.IotaType;
import at.petrak.hexcasting.api.casting.mishaps.MishapInvalidIota;
import at.petrak.hexcasting.api.utils.HexUtils;
import net.minecraft.class_124;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_4614;
import net.minecraft.class_5250;
import org.jblas.DoubleMatrix;
import org.jetbrains.annotations.NotNull;
import ram.talia.moreiotas.api.mod.MoreIotasConfig;
import ram.talia.moreiotas.common.lib.hex.MoreIotasIotaTypes;

public class MatrixIota
extends Iota {
    public static IotaType<MatrixIota> TYPE = new IotaType<MatrixIota>(){

        public MatrixIota deserialize(class_2520 tag, class_3218 world) throws IllegalArgumentException {
            class_2487 ctag = (class_2487)HexUtils.downcast((class_2520)tag, (class_4614)class_2487.field_21029);
            try {
                return new MatrixIota(this.deserialise(ctag));
            }
            catch (MishapInvalidIota e) {
                throw new IllegalArgumentException(e);
            }
        }

        public class_2561 display(class_2520 tag) {
            DoubleMatrix mat;
            if (!(tag instanceof class_2487)) {
                return class_2561.method_43471((String)"hexcasting.spelldata.unknown");
            }
            class_2487 ctag = (class_2487)tag;
            try {
                mat = this.deserialise(ctag);
            }
            catch (IllegalArgumentException e) {
                return class_2561.method_43471((String)"hexcasting.spelldata.unknown");
            }
            class_5250 out = class_2561.method_43473();
            out.method_27693(String.format("(%d, %d)", mat.rows, mat.columns));
            if (!mat.isEmpty()) {
                out.method_27693(" | ");
            }
            for (int r = 0; r < mat.rows; ++r) {
                for (int c = 0; c < mat.columns; ++c) {
                    out.method_10852((class_2561)class_2561.method_43470((String)String.format("%.2f", mat.get(r, c))).method_27692(class_124.field_1060));
                    if (c >= mat.columns - 1) continue;
                    out.method_27693(", ");
                }
                if (r >= mat.rows - 1) continue;
                out.method_27693("; ");
            }
            return class_2561.method_43469((String)"hexcasting.tooltip.list_contents", (Object[])new Object[]{out}).method_27692(class_124.field_1075);
        }

        private DoubleMatrix deserialise(class_2487 ctag) throws IllegalArgumentException {
            if (!(ctag.method_10545(MatrixIota.TAG_ROWS) && ctag.method_10545(MatrixIota.TAG_COLS) && ctag.method_10545(MatrixIota.TAG_MAT))) {
                throw new IllegalArgumentException("expected tags \"rows\": int, \"cols\": int, and \"mat\": list(list(double))");
            }
            int rows = ctag.method_10550(MatrixIota.TAG_ROWS);
            int cols = ctag.method_10550(MatrixIota.TAG_COLS);
            DoubleMatrix mat = new DoubleMatrix(rows, cols);
            class_2499 list = ctag.method_10554(MatrixIota.TAG_MAT, 9);
            for (int i = 0; i < rows; ++i) {
                class_2499 curList = list.method_10603(i);
                for (int j = 0; j < cols; ++j) {
                    mat.put(i, j, curList.method_10611(j));
                }
            }
            return mat;
        }

        public int color() {
            return -11141121;
        }
    };
    private static final String TAG_ROWS = "rows";
    private static final String TAG_COLS = "cols";
    private static final String TAG_MAT = "mat";

    public MatrixIota(@NotNull DoubleMatrix matrix) throws MishapInvalidIota {
        super(MoreIotasIotaTypes.MATRIX, (Object)matrix);
        if (matrix.rows > MoreIotasConfig.getServer().getMaxMatrixSize() || matrix.columns > MoreIotasConfig.getServer().getMaxMatrixSize()) {
            throw MishapInvalidIota.of((Iota)this, (int)0, (String)"matrix.max_size", (Object[])new Object[]{MoreIotasConfig.getServer().getMaxMatrixSize(), matrix.rows, matrix.columns});
        }
    }

    public DoubleMatrix getMatrix() {
        return (DoubleMatrix)this.payload;
    }

    protected boolean toleratesOther(Iota that) {
        return false;
    }

    public boolean isTruthy() {
        return !this.getMatrix().isEmpty() && this.getMatrix().norm1() > 1.0E-4;
    }

    @NotNull
    public class_2520 serialize() {
        class_2487 tag = new class_2487();
        DoubleMatrix mat = this.getMatrix();
        tag.method_10569(TAG_ROWS, mat.rows);
        tag.method_10569(TAG_COLS, mat.columns);
        class_2499 list = new class_2499();
        for (int i = 0; i < mat.rows; ++i) {
            class_2499 curList = new class_2499();
            for (int j = 0; j < mat.columns; ++j) {
                curList.add((Object)class_2489.method_23241((double)mat.get(i, j)));
            }
            list.add((Object)curList);
        }
        tag.method_10566(TAG_MAT, (class_2520)list);
        return tag;
    }
}

