/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.utils;

import com.mojang.datafixers.util.Either;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.utils.ImgFormatParser;
import com.samsthenerd.inline.utils.IntPair;
import com.samsthenerd.inline.utils.SpriteUVLens;
import com.samsthenerd.inline.utils.SpriteUVRegion;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import javax.annotation.Nullable;
import net.minecraft.class_1047;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3545;

public class URLTextureUtils {
    private static final Map<class_2960, LoadingState> LOADING_TEXTURE_STATES = Collections.synchronizedMap(new HashMap());
    private static final class_3545<IntPair, SpriteUVLens> ERROR_TEXT_INFO = new class_3545((Object)new IntPair(16, 16), (Object)SpriteUVRegion.FULL.asLens());

    @Nullable
    public static class_2960 loadTextureFromURL(String urlStr, class_2960 textureId) {
        LoadingState state = LOADING_TEXTURE_STATES.get(textureId);
        if (state == LoadingState.IN_PROGRESS) {
            return null;
        }
        if (state == LoadingState.ERROR) {
            return class_1047.method_4539();
        }
        if (state instanceof LoadingState.SuccessState) {
            LoadingState.SuccessState succSt = (LoadingState.SuccessState)state;
            return succSt.textId();
        }
        if (state != null) {
            return class_1047.method_4539();
        }
        LOADING_TEXTURE_STATES.put(textureId, LoadingState.IN_PROGRESS);
        CompletableFuture.runAsync(() -> {
            try {
                ImgFormatParser parser;
                Either<ImgFormatParser.ImgParseResult, String> imgResult;
                URL textureUrl = URI.create(urlStr).toURL();
                URLConnection conn = textureUrl.openConnection();
                InputStream stream = conn.getInputStream();
                String contentType = URLConnection.guessContentTypeFromStream(stream);
                if (contentType == null) {
                    contentType = conn.getContentType();
                }
                if ((imgResult = (parser = ImgFormatParser.getFormatParser(contentType)).tryParse(stream, contentType)).left().isPresent()) {
                    ImgFormatParser.ImgParseResult res = (ImgFormatParser.ImgParseResult)imgResult.left().get();
                    class_310.method_1551().execute(() -> LOADING_TEXTURE_STATES.put(textureId, new LoadingState.SuccessState(res.dims(), res.lens(), res.registerTextureCallback().apply(textureId))));
                } else {
                    String err = (String)imgResult.right().get();
                    Inline.LOGGER.error("Failed to parse image " + urlStr + " : " + err);
                    LOADING_TEXTURE_STATES.put(textureId, LoadingState.ERROR);
                }
            }
            catch (IOException e) {
                Inline.LOGGER.error("Failed to parse image " + urlStr + " : " + e);
                LOADING_TEXTURE_STATES.put(textureId, LoadingState.ERROR);
            }
        });
        return null;
    }

    @Nullable
    public static class_3545<IntPair, SpriteUVLens> getTextureInfo(class_2960 textureId) {
        LoadingState state = LOADING_TEXTURE_STATES.get(textureId);
        if (state == LoadingState.IN_PROGRESS) {
            return null;
        }
        if (state == LoadingState.ERROR) {
            return ERROR_TEXT_INFO;
        }
        if (state instanceof LoadingState.SuccessState) {
            LoadingState.SuccessState succSt = (LoadingState.SuccessState)state;
            return new class_3545((Object)succSt.dims, (Object)succSt.lens());
        }
        return null;
    }

    static {
        ImgFormatParser.loadBuiltinParsers();
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static interface LoadingState {
        public static final LoadingState ERROR = new StrState("error");
        public static final LoadingState IN_PROGRESS = new StrState("progress");

        public record StrState(String st) implements LoadingState
        {
        }

        public record SuccessState(IntPair dims, SpriteUVLens lens, class_2960 textId) implements LoadingState
        {
        }
    }
}

