/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.impl;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.JsonOps;
import com.samsthenerd.inline.Inline;
import com.samsthenerd.inline.api.InlineAPI;
import com.samsthenerd.inline.api.InlineData;
import com.samsthenerd.inline.api.matching.InlineMatcher;
import com.samsthenerd.inline.impl.InlineStyle;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import org.slf4j.Logger;

public class InlineImpl
implements InlineAPI {
    private static final Map<class_2960, InlineData.InlineDataType<?>> DATA_TYPES = new HashMap();
    private static final Codec<InlineData.InlineDataType<?>> INLINE_DATA_TYPE_CODEC = class_2960.field_25139.comapFlatMap(id -> DATA_TYPES.containsKey(id) ? DataResult.success(DATA_TYPES.get(id)) : DataResult.error(() -> "No inline data type: " + id.toString()), InlineData.InlineDataType::getId);
    public static final Codec<InlineData<?>> INLINE_DATA_CODEC = INLINE_DATA_TYPE_CODEC.dispatch("type", InlineData::getType, InlineData.InlineDataType::getCodec);
    public static final Set<InlineMatcher> SERVER_CHAT_MATCHERS = new HashSet<InlineMatcher>();

    @Override
    public void addDataType(InlineData.InlineDataType<?> type) {
        DATA_TYPES.put(type.getId(), type);
    }

    @Override
    @Nullable
    public <D extends InlineData<D>> D deserializeData(JsonObject json) {
        String type = json.get("type").getAsString();
        if (!DATA_TYPES.containsKey(new class_2960(type))) {
            return null;
        }
        InlineData.InlineDataType<?> dType = DATA_TYPES.get(new class_2960(type));
        return (D)((InlineData)dType.getCodec().parse((DynamicOps)JsonOps.INSTANCE, (Object)json.get("data")).getOrThrow(false, arg_0 -> ((Logger)Inline.LOGGER).error(arg_0)));
    }

    @Override
    public <D extends InlineData<D>> JsonObject serializeData(D data) {
        InlineData.InlineDataType<D> dType = data.getType();
        JsonObject json = new JsonObject();
        Optional dataElem = dType.getCodec().encodeStart((DynamicOps)JsonOps.INSTANCE, data).result();
        json.addProperty("type", data.getType().toString());
        json.add("data", (JsonElement)dataElem.orElse(new JsonObject()));
        return json;
    }

    @Override
    public class_2583 withSizeModifier(class_2583 style, double modifier) {
        return style.withComponent(InlineStyle.SIZE_MODIFIER_COMP, (Object)modifier);
    }

    @Override
    public void addChatMatcher(InlineMatcher matcher) {
        SERVER_CHAT_MATCHERS.add(matcher);
    }
}

