/*
 * Decompiled with CFR 0.152.
 */
package com.samsthenerd.inline.api.matching;

import com.samsthenerd.inline.api.InlineData;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5224;

public interface InlineMatch {
    public int accept(class_5224 var1, int var2, class_2583 var3);

    public int charLength();

    public static class TextMatch
    implements InlineMatch {
        private class_2561 text;

        public TextMatch(class_2561 text) {
            this.text = text;
        }

        @Override
        public int accept(class_5224 visitor, int index, class_2583 currentStyle) {
            if (this.text.getString().equals("")) {
                return 1;
            }
            AtomicInteger offset = new AtomicInteger(0);
            this.text.method_27658((style, str) -> {
                for (char c : str.toCharArray()) {
                    visitor.accept(index + offset.get(), style.method_27702(currentStyle), (int)c);
                    offset.incrementAndGet();
                }
                return Optional.empty();
            }, currentStyle);
            return offset.get();
        }

        @Override
        public int charLength() {
            return Math.max(this.text.getString().length(), 1);
        }
    }

    public static class DataMatch
    implements InlineMatch {
        public final InlineData data;
        public final class_2583 style;

        public DataMatch(InlineData data, class_2583 style) {
            this.data = data;
            this.style = style;
        }

        public DataMatch(InlineData data) {
            this(data, class_2583.field_24360);
        }

        @Override
        public int accept(class_5224 visitor, int index, class_2583 currentStyle) {
            class_2583 nonDataStyle = this.style.method_27702(currentStyle);
            class_2583 dataStyle = nonDataStyle.withInlineData(this.data);
            visitor.accept(index, dataStyle, 46);
            return 1;
        }

        @Override
        public int charLength() {
            return 1;
        }
    }
}

