/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import com.google.errorprone.annotations.Keep;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import net.minecraft.class_2806;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_5321;
import net.minecraft.class_8563;

public final class TickScheduler {
    private static final Queue<Token> toTick = new ConcurrentLinkedDeque<Token>();
    private static final Map<ChunkReference, List<Token>> delayed = new HashMap<ChunkReference, List<Token>>();

    private TickScheduler() {
    }

    public static void schedule(Token token) {
        class_1937 world = token.owner.method_10997();
        if (world != null && !world.field_9236 && Token.STATE.compareAndSet(token, State.IDLE, State.SCHEDULED)) {
            toTick.add(token);
        }
    }

    public static void onChunkTicketChanged(class_3218 level, long chunkPos, int oldLevel, int newLevel) {
        boolean oldLoaded = TickScheduler.isLoaded(oldLevel);
        boolean newLoaded = TickScheduler.isLoaded(newLevel);
        if (!oldLoaded && newLoaded) {
            List<Token> delayedTokens = delayed.remove(new ChunkReference((class_5321<class_1937>)level.method_27983(), chunkPos));
            if (delayedTokens == null) {
                return;
            }
            for (Token token : delayedTokens) {
                if (token.owner.method_11015()) {
                    Token.STATE.set(token, State.IDLE);
                    continue;
                }
                Token.STATE.set(token, State.SCHEDULED);
                toTick.add(token);
            }
        }
    }

    public static void onChunkUnload(class_2818 chunk) {
        List<Token> delayedTokens = delayed.remove(new ChunkReference((class_5321<class_1937>)chunk.method_12200().method_27983(), chunk.method_12004().method_8324()));
        if (delayedTokens == null) {
            return;
        }
        for (Token token : delayedTokens) {
            Token.STATE.set(token, State.IDLE);
        }
    }

    public static void tick() {
        Token token;
        while ((token = toTick.poll()) != null) {
            Token.STATE.set(token, TickScheduler.tickToken(token));
        }
    }

    private static State tickToken(Token token) {
        class_2338 pos;
        class_2586 blockEntity = token.owner;
        if (blockEntity.method_11015()) {
            return State.IDLE;
        }
        class_1937 level = Objects.requireNonNull(blockEntity.method_10997(), "Block entity level cannot become null");
        if (!level.method_8477(pos = blockEntity.method_11016())) {
            delayed.computeIfAbsent(new ChunkReference((class_5321<class_1937>)level.method_27983(), class_1923.method_37232((class_2338)pos)), x -> new ArrayList()).add(token);
            return State.UNLOADED;
        }
        class_2586 currentBlockEntity = level.method_8321(pos);
        if (currentBlockEntity != blockEntity) {
            throw new IllegalStateException("Expected " + blockEntity + " at " + pos + ", got " + currentBlockEntity);
        }
        level.method_39279(pos, blockEntity.method_11010().method_26204(), 0);
        return State.IDLE;
    }

    private static boolean isLoaded(int level) {
        return level <= class_8563.method_51829((class_2806)class_2806.field_12803);
    }

    public static class Token {
        static final AtomicReferenceFieldUpdater<Token, State> STATE = AtomicReferenceFieldUpdater.newUpdater(Token.class, State.class, "$state");
        final class_2586 owner;
        @Keep
        private volatile State $state = State.IDLE;

        public Token(class_2586 owner) {
            this.owner = owner;
        }
    }

    private static enum State {
        IDLE,
        SCHEDULED,
        UNLOADED;

    }

    private record ChunkReference(class_5321<class_1937> level, Long position) {
        @Override
        public String toString() {
            return "ChunkReference(" + this.level + " at " + new class_1923(this.position.longValue()) + ")";
        }
    }
}

