/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.util;

import java.util.AbstractList;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.Nullable;

public final class ConsList<T>
extends AbstractList<T> {
    private final T head;
    private final List<T> tail;

    public ConsList(T head, List<T> tail) {
        this.head = head;
        this.tail = tail;
    }

    @Override
    public T get(int index) {
        return index == 0 ? this.head : this.tail.get(index - 1);
    }

    @Override
    public int size() {
        return 1 + this.tail.size();
    }

    @Override
    public Iterator<T> iterator() {
        return new Iterator<T>(){
            @Nullable
            private Iterator<T> tailIterator;

            @Override
            public boolean hasNext() {
                return this.tailIterator == null || this.tailIterator.hasNext();
            }

            @Override
            public T next() {
                if (this.tailIterator != null) {
                    return this.tailIterator.next();
                }
                this.tailIterator = ConsList.this.tail.iterator();
                return ConsList.this.head;
            }
        };
    }
}

