/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.peripheral.generic;

import dan200.computercraft.api.peripheral.IPeripheral;
import dan200.computercraft.core.methods.MethodSupplier;
import dan200.computercraft.core.methods.PeripheralMethod;
import dan200.computercraft.shared.computer.core.ServerContext;
import dan200.computercraft.shared.peripheral.generic.ComponentLookup;
import dan200.computercraft.shared.peripheral.generic.GenericPeripheralBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_3218;

public final class GenericPeripheralProvider<C extends Runnable> {
    private final List<ComponentLookup<? super C>> lookups = new ArrayList<ComponentLookup<? super C>>();

    public synchronized void registerLookup(ComponentLookup<? super C> lookup) {
        Objects.requireNonNull(lookup);
        if (!this.lookups.contains(lookup)) {
            this.lookups.add(lookup);
        }
    }

    public void forEachMethod(MethodSupplier<PeripheralMethod> methods, class_3218 level, class_2338 pos, class_2350 side, class_2586 blockEntity, C invalidate, MethodSupplier.TargetedConsumer<PeripheralMethod> consumer) {
        methods.forEachMethod(blockEntity, consumer);
        for (ComponentLookup<C> lookup : this.lookups) {
            Object contents = lookup.find(level, pos, blockEntity.method_11010(), blockEntity, side, invalidate);
            if (contents == null) continue;
            methods.forEachMethod(contents, consumer);
        }
    }

    @Nullable
    public IPeripheral getPeripheral(class_3218 level, class_2338 pos, class_2350 side, @Nullable class_2586 blockEntity, C invalidate) {
        if (blockEntity == null) {
            return null;
        }
        GenericPeripheralBuilder builder = new GenericPeripheralBuilder();
        this.forEachMethod(ServerContext.get(level.method_8503()).peripheralMethods(), level, pos, side, blockEntity, invalidate, builder::addMethod);
        return builder.toPeripheral(blockEntity, side);
    }
}

