/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.mixin.client;

import com.jozufozu.flywheel.core.PartialModel;
import com.jozufozu.flywheel.util.transform.TransformStack;
import com.railwayteam.railways.content.custom_tracks.casing.CasingRenderUtils;
import com.railwayteam.railways.mixin_interfaces.IHasTrackCasing;
import com.railwayteam.railways.mixin_interfaces.IMonorailBezier;
import com.railwayteam.railways.registry.CRBlockPartials;
import com.railwayteam.railways.registry.CRTrackMaterials;
import com.railwayteam.railways.util.client.ClientTextUtils;
import com.simibubi.create.content.trains.track.BezierConnection;
import com.simibubi.create.content.trains.track.TrackBlock;
import com.simibubi.create.content.trains.track.TrackBlockEntity;
import com.simibubi.create.content.trains.track.TrackMaterial;
import com.simibubi.create.content.trains.track.TrackRenderer;
import com.simibubi.create.content.trains.track.TrackShape;
import com.simibubi.create.foundation.render.CachedBufferer;
import com.simibubi.create.foundation.render.SuperByteBuffer;
import com.simibubi.create.foundation.utility.Iterate;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2482;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Mixin(value={TrackRenderer.class}, remap=false)
public class MixinTrackRenderer {
    @Inject(method={"renderSafe(Lcom/simibubi/create/content/trains/track/TrackBlockEntity;FLcom/mojang/blaze3d/vertex/PoseStack;Lnet/minecraft/client/renderer/MultiBufferSource;II)V"}, at={@At(value="INVOKE", target="Lnet/minecraft/client/renderer/MultiBufferSource;getBuffer(Lnet/minecraft/client/renderer/RenderType;)Lcom/mojang/blaze3d/vertex/VertexConsumer;")}, remap=true)
    private void renderCasing(TrackBlockEntity te, float partialTicks, class_4587 ms, class_4597 buffer, int light, int overlay, CallbackInfo ci) {
        class_2482 casingBlock = ((IHasTrackCasing)te).getTrackCasing();
        if (casingBlock != null) {
            TrackShape shape = (TrackShape)te.method_11010().method_11654((class_2769)TrackBlock.SHAPE);
            if (CRBlockPartials.TRACK_CASINGS.containsKey(shape)) {
                ms.method_22903();
                if (te.isTilted()) {
                    double angle = (Double)te.tilt.smoothingAngle.get();
                    switch ((TrackShape)te.method_11010().method_11654((class_2769)TrackBlock.SHAPE)) {
                        case ZO: {
                            TransformStack.cast((class_4587)ms).rotateX(-angle);
                            break;
                        }
                        case XO: {
                            TransformStack.cast((class_4587)ms).rotateZ(angle);
                        }
                    }
                }
                TrackMaterial.TrackType trackType = null;
                class_2248 class_22482 = te.method_11010().method_26204();
                if (class_22482 instanceof TrackBlock) {
                    TrackBlock trackBlock = (TrackBlock)class_22482;
                    trackType = trackBlock.getMaterial().trackType;
                }
                CRBlockPartials.TrackCasingSpec spec = CRBlockPartials.TRACK_CASINGS.get(shape);
                spec = ((IHasTrackCasing)te).isAlternate() ? spec.getNonNullAltSpec(trackType) : spec.getFor(trackType);
                CRBlockPartials.ModelTransform transform = spec.transform;
                PartialModel texturedPartial = CasingRenderUtils.reTexture(spec.model, casingBlock);
                ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)CasingRenderUtils.reTexture(spec.model, casingBlock), (class_2680)casingBlock.method_9564()).rotateX((double)transform.rx())).rotateY((double)transform.ry())).rotateZ((double)transform.rz())).translate(transform.x(), transform.y(), transform.z()).light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
                for (CRBlockPartials.ModelTransform additionalTransform : spec.additionalTransforms) {
                    ((SuperByteBuffer)((SuperByteBuffer)((SuperByteBuffer)CachedBufferer.partial((PartialModel)texturedPartial, (class_2680)casingBlock.method_9564()).rotateX((double)additionalTransform.rx())).rotateY((double)additionalTransform.ry())).rotateZ((double)additionalTransform.rz())).translate(additionalTransform.x(), additionalTransform.y(), additionalTransform.z()).light(light).renderInto(ms, buffer.getBuffer(class_1921.method_23579()));
                }
                ms.method_22909();
            } else {
                ClientTextUtils.renderDebugText(ms, buffer, light, 1.0, true, "No casing for shape " + shape);
            }
        }
    }

    @Inject(method={"renderBezierTurn"}, at={@At(value="INVOKE", target="Lcom/mojang/blaze3d/vertex/PoseStack;pushPose()V", remap=true)}, remap=false)
    private static void renderCurveCasings(class_1937 level, BezierConnection bc, class_4587 ms, class_4588 vb, CallbackInfo ci) {
        class_2482 casingBlock = ((IHasTrackCasing)bc).getTrackCasing();
        if (casingBlock != null) {
            CasingRenderUtils.renderBezierCasings(ms, level, CasingRenderUtils.reTexture(CRBlockPartials.TRACK_CASING_FLAT_THICK, casingBlock), casingBlock.method_9564(), vb, bc);
        }
    }

    @Inject(method={"renderBezierTurn"}, at={@At(value="INVOKE", target="Lcom/simibubi/create/content/trains/track/TrackRenderer;renderGirder(Lnet/minecraft/world/level/Level;Lcom/simibubi/create/content/trains/track/BezierConnection;Lcom/mojang/blaze3d/vertex/PoseStack;Lcom/mojang/blaze3d/vertex/VertexConsumer;Lnet/minecraft/core/BlockPos;)V", shift=At.Shift.AFTER, remap=true)}, cancellable=true)
    private static void renderMonorailMaybe(class_1937 level, BezierConnection bc, class_4587 ms, class_4588 vb, CallbackInfo ci) {
        if (bc.getMaterial().trackType == CRTrackMaterials.CRTrackType.MONORAIL) {
            MixinTrackRenderer.railways$renderActualMonorail(level, bc, ms, vb, (class_2338)bc.tePositions.getFirst());
            ms.method_22909();
            ci.cancel();
        }
    }

    @Unique
    private static void railways$renderActualMonorail(class_1937 level, BezierConnection bc, class_4587 ms, class_4588 vb, class_2338 tePosition) {
        class_2680 air = class_2246.field_10124.method_9564();
        IMonorailBezier.MonorailAngles[] monorails = ((IMonorailBezier)bc).getBakedMonorails();
        for (int i = 1; i < monorails.length; ++i) {
            IMonorailBezier.MonorailAngles segment = monorails[i];
            int light = class_761.method_23794((class_1920)level, (class_2338)segment.lightPosition.method_10081((class_2382)tePosition));
            class_4587.class_4665 beamTransform = segment.beam;
            CachedBufferer.partial((PartialModel)CRBlockPartials.MONORAIL_SEGMENT_MIDDLE, (class_2680)air).mulPose(beamTransform.method_23761()).mulNormal(beamTransform.method_23762()).light(light).renderInto(ms, vb);
            for (boolean top : Iterate.trueAndFalse) {
                class_4587.class_4665 beamCapTransform = (class_4587.class_4665)segment.beamCaps.get(top);
                CachedBufferer.partial((PartialModel)(top ? CRBlockPartials.MONORAIL_SEGMENT_TOP : CRBlockPartials.MONORAIL_SEGMENT_BOTTOM), (class_2680)air).mulPose(beamCapTransform.method_23761()).mulNormal(beamCapTransform.method_23762()).light(light).renderInto(ms, vb);
            }
        }
    }
}

