/*
 * Decompiled with CFR 0.152.
 */
package com.railwayteam.railways.content.buffer.headstock.fabric;

import com.railwayteam.railways.content.buffer.BufferModelUtils;
import com.railwayteam.railways.content.buffer.IDyedBuffer;
import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBarsBlock;
import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBlock;
import com.railwayteam.railways.content.buffer.headstock.CopycatHeadstockBlockEntity;
import com.railwayteam.railways.content.buffer.headstock.fabric.CopycatHeadstockBarsModel;
import com.railwayteam.railways.registry.CRBlocks;
import com.simibubi.create.AllBlocks;
import com.simibubi.create.content.decoration.copycat.CopycatBlock;
import com.simibubi.create.content.decoration.copycat.CopycatModel;
import com.simibubi.create.content.decoration.copycat.CopycatSpecialCases;
import com.simibubi.create.foundation.model.BakedModelHelper;
import com.simibubi.create.foundation.utility.Iterate;
import java.util.List;
import java.util.Objects;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.function.UnaryOperator;
import javax.annotation.ParametersAreNonnullByDefault;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.renderer.v1.RendererAccess;
import net.fabricmc.fabric.api.renderer.v1.material.BlendMode;
import net.fabricmc.fabric.api.renderer.v1.material.MaterialFinder;
import net.fabricmc.fabric.api.renderer.v1.material.RenderMaterial;
import net.fabricmc.fabric.api.renderer.v1.mesh.MeshBuilder;
import net.fabricmc.fabric.api.renderer.v1.mesh.MutableQuadView;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadEmitter;
import net.fabricmc.fabric.api.renderer.v1.mesh.QuadView;
import net.fabricmc.fabric.api.renderer.v1.model.ForwardingBakedModel;
import net.fabricmc.fabric.api.renderer.v1.model.SpriteFinder;
import net.fabricmc.fabric.api.renderer.v1.render.RenderContext;
import net.minecraft.class_1058;
import net.minecraft.class_1059;
import net.minecraft.class_1087;
import net.minecraft.class_1723;
import net.minecraft.class_1767;
import net.minecraft.class_1799;
import net.minecraft.class_1920;
import net.minecraft.class_1921;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2512;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_4696;
import net.minecraft.class_5819;
import net.minecraft.class_6328;
import net.minecraft.class_777;
import net.minecraft.class_7871;
import net.minecraft.class_7923;
import net.minecraft.class_806;
import net.minecraft.class_809;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@ParametersAreNonnullByDefault
@class_6328
@Environment(value=EnvType.CLIENT)
public class CopycatHeadstockModel
extends ForwardingBakedModel {
    protected static final class_238 CUBE_AABB = new class_238(class_2338.field_10980);

    public CopycatHeadstockModel(class_1087 wrapped) {
        this.wrapped = wrapped;
    }

    private void gatherOcclusionData(class_1920 world, class_2338 pos, class_2680 state, class_2680 material, OcclusionData occlusionData, CopycatBlock copycatBlock) {
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        for (class_2350 face : Iterate.directions) {
            class_2338.class_2339 neighbourPos;
            if (!copycatBlock.canFaceBeOccluded(state, face) || class_2248.method_9607((class_2680)material, (class_1922)world, (class_2338)pos, (class_2350)face, (class_2338)(neighbourPos = mutablePos.method_25505((class_2382)pos, face)))) continue;
            occlusionData.occlude(face);
        }
    }

    public boolean isVanillaAdapter() {
        return false;
    }

    private static boolean filterCopycatParts(class_777 quad) {
        return !quad.method_35788().method_45851().method_45816().equals((Object)new class_2960("create", "block/copycat_base"));
    }

    public void emitBlockQuads(class_1920 blockView, class_2680 state, class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context) {
        boolean shouldTransform;
        class_2680 material;
        IDyedBuffer be;
        UnaryOperator<class_1058> colorSwapper = null;
        class_2586 class_25862 = blockView.method_8321(pos);
        if (class_25862 instanceof IDyedBuffer) {
            be = (IDyedBuffer)class_25862;
            colorSwapper = BufferModelUtils.getSwapper(be.getColor());
        }
        if ((class_25862 = blockView.method_8321(pos)) instanceof CopycatHeadstockBlockEntity) {
            be = (CopycatHeadstockBlockEntity)class_25862;
            material = be.getMaterial();
        } else {
            material = AllBlocks.COPYCAT_BASE.getDefaultState();
        }
        if (colorSwapper != null) {
            context.bakedModelConsumer().accept((class_1087)new SpriteReplacingBakedModel(colorSwapper, CopycatHeadstockModel::filterCopycatParts), state);
        } else {
            context.bakedModelConsumer().accept((class_1087)new SpriteReplacingBakedModel(CopycatHeadstockModel::filterCopycatParts), state);
        }
        OcclusionData occlusionData = new OcclusionData();
        class_2248 class_22482 = state.method_26204();
        if (class_22482 instanceof CopycatBlock) {
            CopycatBlock copycatBlock = (CopycatBlock)class_22482;
            this.gatherOcclusionData(blockView, pos, state, material, occlusionData, copycatBlock);
        }
        CullFaceRemovalData cullFaceRemovalData = new CullFaceRemovalData();
        class_2350[] class_2350Array = state.method_26204();
        if (class_2350Array instanceof CopycatBlock) {
            CopycatBlock copycatBlock = (CopycatBlock)class_2350Array;
            for (class_2350 cullFace : Iterate.directions) {
                if (!copycatBlock.shouldFaceAlwaysRender(state, cullFace)) continue;
                cullFaceRemovalData.remove(cullFace);
            }
        }
        boolean bl = shouldTransform = material != AllBlocks.COPYCAT_BASE.getDefaultState();
        if (shouldTransform) {
            context.pushTransform((RenderContext.QuadTransform)MaterialFixer.create(material));
        }
        this.emitBlockQuadsInner(blockView, state, pos, randomSupplier, context, material, cullFaceRemovalData, occlusionData);
        if (shouldTransform) {
            context.popTransform();
        }
    }

    protected void emitBlockQuadsInner(@Nullable class_1920 blockView, @Nullable class_2680 state, @Nullable class_2338 pos, Supplier<class_5819> randomSupplier, RenderContext context, class_2680 material, CullFaceRemovalData cullFaceRemovalData, OcclusionData occlusionData) {
        class_2680 specialState;
        class_1087 specialModel;
        boolean upsideDown;
        class_2350 facing = state == null ? class_2350.field_11043 : state.method_28500((class_2769)CopycatHeadstockBlock.FACING).orElse(class_2350.field_11043);
        boolean bl = upsideDown = state != null && (Boolean)state.method_11654((class_2769)CopycatHeadstockBlock.UPSIDE_DOWN) != false;
        if (CopycatSpecialCases.isBarsMaterial((class_2680)material) && (specialModel = CopycatModel.getModelOf((class_2680)(specialState = (class_2680)((class_2680)CRBlocks.COPYCAT_HEADSTOCK_BARS.getDefaultState().method_11657((class_2769)CopycatHeadstockBarsBlock.field_11177, (Comparable)facing)).method_11657((class_2769)CopycatHeadstockBarsBlock.UPSIDE_DOWN, (Comparable)Boolean.valueOf(upsideDown))))) instanceof CopycatHeadstockBarsModel) {
            CopycatHeadstockBarsModel cm = (CopycatHeadstockBarsModel)specialModel;
            cm.emitBlockQuadsInner(blockView, state, pos, randomSupplier, context, material, cullFaceRemovalData.shouldRemove, occlusionData.occluded);
            return;
        }
        class_1087 model = CopycatModel.getModelOf((class_2680)material);
        class_243 normal = class_243.method_24954((class_2382)facing.method_10163());
        class_243 normalScaled14 = normal.method_1021(0.875);
        SpriteFinder spriteFinder = SpriteFinder.get((class_1059)class_310.method_1551().method_1554().method_24153(class_1723.field_21668));
        MeshBuilder meshBuilder = RendererAccess.INSTANCE.getRenderer().meshBuilder();
        QuadEmitter emitter = meshBuilder.getEmitter();
        context.pushTransform(quad -> {
            if (cullFaceRemovalData.shouldRemove(quad.cullFace())) {
                quad.cullFace(null);
            } else if (occlusionData.isOccluded(quad.cullFace())) {
                RenderMaterial quadMaterial = quad.material();
                quad.copyTo((MutableQuadView)emitter);
                emitter.material(quadMaterial);
                emitter.emit();
                return false;
            }
            for (boolean top : Iterate.trueAndFalse) {
                for (boolean front : Iterate.trueAndFalse) {
                    class_243 offset = normal.method_1021(front ? 0.0 : -0.8125);
                    float contract = 16 - (front ? 1 : 2);
                    class_238 bb = CUBE_AABB.method_1002(normal.field_1352 * (double)contract / 16.0, 0.625, normal.field_1350 * (double)contract / 16.0);
                    if (!front) {
                        bb = bb.method_997(normalScaled14);
                    }
                    if (top) {
                        bb = bb.method_989(0.0, 0.625, 0.0);
                    } else {
                        offset = offset.method_1031(0.0, 0.25, 0.0);
                    }
                    if (upsideDown) {
                        offset = offset.method_1031(0.0, -0.25, 0.0);
                    }
                    class_2350 direction = quad.lightFace();
                    if (front && direction == facing || !front && direction == facing.method_10153() || top && direction == class_2350.field_11033 || !top && direction == class_2350.field_11036) continue;
                    RenderMaterial quadMaterial = quad.material();
                    quad.copyTo((MutableQuadView)emitter);
                    emitter.material(quadMaterial);
                    BakedModelHelper.cropAndMove((MutableQuadView)emitter, (class_1058)spriteFinder.find((QuadView)emitter, 0), (class_238)bb, (class_243)offset);
                    emitter.emit();
                }
            }
            return false;
        });
        if (blockView == null || pos == null || state == null) {
            model.emitItemQuads(new class_1799((class_1935)material.method_26204().method_8389()), randomSupplier, context);
        } else {
            model.emitBlockQuads(blockView, material, pos, randomSupplier, context);
        }
        context.popTransform();
        context.meshConsumer().accept(meshBuilder.build());
    }

    public void emitItemQuads(class_1799 stack, Supplier<class_5819> randomSupplier, RenderContext context) {
        class_2487 tag;
        class_2680 material = AllBlocks.COPYCAT_BASE.getDefaultState();
        UnaryOperator<class_1058> colorSwapper = null;
        if (stack.method_7985() && (tag = stack.method_7969()).method_10573("BlockEntityTag", 10)) {
            class_2487 blockEntityTag = tag.method_10562("BlockEntityTag");
            if (blockEntityTag.method_10573("Material", 10)) {
                material = class_2512.method_10681((class_7871)class_7923.field_41175.method_46771(), (class_2487)blockEntityTag.method_10562("Material"));
            }
            if (blockEntityTag.method_10573("Color", 3)) {
                colorSwapper = BufferModelUtils.getSwapper(class_1767.method_7791((int)blockEntityTag.method_10550("Color")));
            }
        }
        if (colorSwapper != null) {
            context.bakedModelConsumer().accept((class_1087)new SpriteReplacingBakedModel(colorSwapper, CopycatHeadstockModel::filterCopycatParts));
        } else {
            context.bakedModelConsumer().accept((class_1087)new SpriteReplacingBakedModel(CopycatHeadstockModel::filterCopycatParts));
        }
        OcclusionData occlusionData = new OcclusionData();
        CullFaceRemovalData cullFaceRemovalData = new CullFaceRemovalData();
        this.emitBlockQuadsInner(null, null, null, randomSupplier, context, material, cullFaceRemovalData, occlusionData);
    }

    protected static class OcclusionData {
        private final boolean[] occluded = new boolean[6];

        public void occlude(class_2350 face) {
            this.occluded[face.method_10146()] = true;
        }

        public boolean isOccluded(@Nullable class_2350 face) {
            return face != null && this.occluded[face.method_10146()];
        }
    }

    private class SpriteReplacingBakedModel
    implements class_1087 {
        private final UnaryOperator<class_1058> spriteSwapper;
        private final Predicate<class_777> filter;

        private SpriteReplacingBakedModel(UnaryOperator<class_1058> spriteSwapper) {
            this(spriteSwapper, quad -> true);
        }

        private SpriteReplacingBakedModel(Predicate<class_777> filter) {
            this(sprite -> sprite, filter);
        }

        private SpriteReplacingBakedModel(UnaryOperator<class_1058> spriteSwapper, Predicate<class_777> filter) {
            this.spriteSwapper = spriteSwapper;
            this.filter = filter;
        }

        @NotNull
        protected List<class_777> filterQuads(@NotNull List<class_777> quads) {
            return quads.stream().filter(this.filter).toList();
        }

        public List<class_777> method_4707(@Nullable class_2680 state, @Nullable class_2350 direction, class_5819 random) {
            return BakedModelHelper.swapSprites(this.filterQuads(CopycatHeadstockModel.this.wrapped.method_4707(state, direction, random)), this.spriteSwapper);
        }

        public boolean method_4708() {
            return CopycatHeadstockModel.this.wrapped.method_4708();
        }

        public boolean method_4712() {
            return CopycatHeadstockModel.this.wrapped.method_4712();
        }

        public boolean method_24304() {
            return CopycatHeadstockModel.this.wrapped.method_24304();
        }

        public boolean method_4713() {
            return CopycatHeadstockModel.this.wrapped.method_4713();
        }

        public class_1058 method_4711() {
            return CopycatHeadstockModel.this.wrapped.method_4711();
        }

        public class_809 method_4709() {
            return CopycatHeadstockModel.this.wrapped.method_4709();
        }

        public class_806 method_4710() {
            return CopycatHeadstockModel.this.wrapped.method_4710();
        }
    }

    protected static class CullFaceRemovalData {
        private final boolean[] shouldRemove = new boolean[6];

        public void remove(class_2350 face) {
            this.shouldRemove[face.method_10146()] = true;
        }

        public boolean shouldRemove(@Nullable class_2350 face) {
            return face != null && this.shouldRemove[face.method_10146()];
        }
    }

    private record MaterialFixer(RenderMaterial materialDefault) implements RenderContext.QuadTransform
    {
        public boolean transform(MutableQuadView quad) {
            if (quad.material().blendMode() == BlendMode.DEFAULT) {
                quad.material(this.materialDefault);
            }
            return true;
        }

        public static MaterialFixer create(class_2680 materialState) {
            class_1921 type = class_4696.method_23679((class_2680)materialState);
            BlendMode blendMode = BlendMode.fromRenderLayer((class_1921)type);
            MaterialFinder finder = Objects.requireNonNull(RendererAccess.INSTANCE.getRenderer()).materialFinder();
            RenderMaterial renderMaterial = finder.blendMode(0, blendMode).find();
            return new MaterialFixer(renderMaterial);
        }
    }
}

