/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.webserver;

import de.maxhenkel.audioplayer.AudioPlayer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.UUID;
import javax.annotation.Nullable;

public class UrlUtils {
    @Nullable
    public static String generateUploadUrl(UUID token) {
        URL url;
        String urlString = AudioPlayer.WEB_SERVER_CONFIG.url.get();
        if (urlString.isBlank()) {
            return null;
        }
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            AudioPlayer.LOGGER.error("Invalid web server URL: {}", (Object)urlString);
            return null;
        }
        StringBuilder finalUrl = new StringBuilder();
        if (url.getProtocol() == null || url.getProtocol().isEmpty() || url.getProtocol().equals("http")) {
            finalUrl.append("http");
        } else if (url.getProtocol().equals("https")) {
            finalUrl.append("https");
        } else {
            AudioPlayer.LOGGER.error("Invalid web server URL protocol: {}", (Object)url.getProtocol());
            return null;
        }
        finalUrl.append("://");
        if (url.getHost().isEmpty()) {
            AudioPlayer.LOGGER.error("Invalid web server URL host: {}", (Object)url.getHost());
            return null;
        }
        finalUrl.append(url.getHost());
        if (url.getPort() != -1) {
            finalUrl.append(":");
            finalUrl.append(url.getPort());
        }
        finalUrl.append("?token=");
        finalUrl.append(token.toString());
        return finalUrl.toString();
    }
}

