/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.webserver;

import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Stream;
import javax.annotation.Nullable;

public class StaticFileCache {
    private final Map<String, byte[]> cache;

    public StaticFileCache(Map<String, byte[]> cache) {
        this.cache = cache;
    }

    @Nullable
    public byte[] get(String path) {
        return this.cache.get(path);
    }

    public static StaticFileCache of(String resourceFolder) throws IOException, URISyntaxException {
        HashMap<String, byte[]> cache = new HashMap<String, byte[]>();
        URL url = StaticFileCache.class.getClassLoader().getResource(resourceFolder);
        if (url == null) {
            throw new IOException("Resource not found: %s".formatted(resourceFolder));
        }
        Path root = Paths.get(url.toURI());
        List<Path> resources = StaticFileCache.getRecursive(root);
        for (Path path : resources) {
            cache.put(StaticFileCache.pathToString(root.relativize(path)), Files.readAllBytes(path));
        }
        return new StaticFileCache(cache);
    }

    private static String pathToString(Path path) {
        StringBuilder sb = new StringBuilder();
        for (Path p : path) {
            sb.append("/");
            sb.append(p);
        }
        if (sb.isEmpty()) {
            sb.append("/");
        }
        return sb.toString();
    }

    private static List<Path> getRecursive(Path path) throws IOException {
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptyList();
        }
        if (!Files.isDirectory(path, new LinkOption[0])) {
            return List.of(path);
        }
        try (Stream<Path> stream = Files.list(path);){
            List<Path> contents = stream.toList();
            ArrayList<Path> paths = new ArrayList<Path>();
            for (Path file : contents) {
                paths.addAll(StaticFileCache.getRecursive(file));
            }
            ArrayList<Path> arrayList = paths;
            return arrayList;
        }
    }
}

