/*
 * Decompiled with CFR 0.152.
 */
package de.maxhenkel.audioplayer.microhttp;

import de.maxhenkel.audioplayer.microhttp.LogEntry;
import de.maxhenkel.audioplayer.microhttp.Logger;
import java.time.Duration;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public class DebugLogger
implements Logger {
    private final long epoch = System.nanoTime();

    @Override
    public boolean enabled() {
        return true;
    }

    @Override
    public void log(LogEntry ... entries) {
        long uptime = Duration.ofNanos(System.nanoTime() - this.epoch).toMillis();
        String text = Stream.of(entries).map(e -> e.key() + "=" + e.value()).collect(Collectors.joining(", ", "[" + uptime + "] ", ""));
        System.out.println(text);
    }

    @Override
    public void log(Exception e, LogEntry ... entries) {
        e.printStackTrace();
        this.log(entries);
    }
}

